// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata
import aws.sdk.kotlin.services.iam.model.Tag
import aws.sdk.kotlin.services.iam.model.UploadServerCertificateResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class UploadServerCertificateOperationDeserializer: HttpDeserialize<UploadServerCertificateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UploadServerCertificateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUploadServerCertificateError(context, call)
        }
        val builder = UploadServerCertificateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUploadServerCertificateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUploadServerCertificateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModification" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall)
        "KeyPairMismatch" -> KeyPairMismatchExceptionDeserializer().deserialize(context, wrappedCall)
        "EntityAlreadyExists" -> EntityAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceeded" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "MalformedCertificate" -> MalformedCertificateExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInput" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUploadServerCertificateOperationBody(builder: UploadServerCertificateResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("UploadServerCertificateResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("UploadServerCertificateResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap UploadServerCertificate response")
    }
    // end unwrap response wrapper

    val SERVERCERTIFICATEMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ServerCertificateMetadata"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("UploadServerCertificateResult"))
        field(SERVERCERTIFICATEMETADATA_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVERCERTIFICATEMETADATA_DESCRIPTOR.index -> builder.serverCertificateMetadata = deserializeServerCertificateMetadataDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
