// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.ListPoliciesResponse
import aws.sdk.kotlin.services.iam.model.Policy
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ListPoliciesOperationDeserializer: HttpDeserialize<ListPoliciesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListPoliciesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListPoliciesError(context, call)
        }
        val builder = ListPoliciesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListPoliciesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListPoliciesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPoliciesOperationBody(builder: ListPoliciesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ListPoliciesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListPoliciesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ListPolicies response")
    }
    // end unwrap response wrapper

    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val POLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Policies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("ListPoliciesResult"))
        field(ISTRUNCATED_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(POLICIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                POLICIES_DESCRIPTOR.index -> builder.policies =
                    deserializer.deserializeList(POLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Policy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePolicyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
