// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.EntityDetails
import aws.sdk.kotlin.services.iam.model.ErrorDetails
import aws.sdk.kotlin.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.JobStatusType
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetServiceLastAccessedDetailsWithEntitiesOperationDeserializer: HttpDeserialize<GetServiceLastAccessedDetailsWithEntitiesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetServiceLastAccessedDetailsWithEntitiesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetServiceLastAccessedDetailsWithEntitiesError(context, call)
        }
        val builder = GetServiceLastAccessedDetailsWithEntitiesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetServiceLastAccessedDetailsWithEntitiesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetServiceLastAccessedDetailsWithEntitiesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInput" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServiceLastAccessedDetailsWithEntitiesOperationBody(builder: GetServiceLastAccessedDetailsWithEntitiesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetServiceLastAccessedDetailsWithEntitiesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetServiceLastAccessedDetailsWithEntitiesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetServiceLastAccessedDetailsWithEntities response")
    }
    // end unwrap response wrapper

    val ENTITYDETAILSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("EntityDetailsList"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Error"))
    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val JOBCOMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("JobCompletionDate"))
    val JOBCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("JobCreationDate"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("JobStatus"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("GetServiceLastAccessedDetailsWithEntitiesResult"))
        field(ENTITYDETAILSLIST_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(ISTRUNCATED_DESCRIPTOR)
        field(JOBCOMPLETIONDATE_DESCRIPTOR)
        field(JOBCREATIONDATE_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITYDETAILSLIST_DESCRIPTOR.index -> builder.entityDetailsList =
                    deserializer.deserializeList(ENTITYDETAILSLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<EntityDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEntityDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorDetailsDocument(deserializer)
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                JOBCOMPLETIONDATE_DESCRIPTOR.index -> builder.jobCompletionDate = deserializeString().let { Instant.fromIso8601(it) }
                JOBCREATIONDATE_DESCRIPTOR.index -> builder.jobCreationDate = deserializeString().let { Instant.fromIso8601(it) }
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatusType.fromValue(it) }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
