// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.GetAccountAuthorizationDetailsResponse
import aws.sdk.kotlin.services.iam.model.GroupDetail
import aws.sdk.kotlin.services.iam.model.IamException
import aws.sdk.kotlin.services.iam.model.ManagedPolicyDetail
import aws.sdk.kotlin.services.iam.model.RoleDetail
import aws.sdk.kotlin.services.iam.model.UserDetail
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class GetAccountAuthorizationDetailsOperationDeserializer: HttpDeserialize<GetAccountAuthorizationDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAccountAuthorizationDetailsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAccountAuthorizationDetailsError(context, call)
        }
        val builder = GetAccountAuthorizationDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccountAuthorizationDetailsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAccountAuthorizationDetailsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccountAuthorizationDetailsOperationBody(builder: GetAccountAuthorizationDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetAccountAuthorizationDetailsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetAccountAuthorizationDetailsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetAccountAuthorizationDetails response")
    }
    // end unwrap response wrapper

    val GROUPDETAILLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("GroupDetailList"))
    val ISTRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsTruncated"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val POLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Policies"))
    val ROLEDETAILLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("RoleDetailList"))
    val USERDETAILLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UserDetailList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("https://iam.amazonaws.com/doc/2010-05-08/"))
        trait(XmlSerialName("GetAccountAuthorizationDetailsResult"))
        field(GROUPDETAILLIST_DESCRIPTOR)
        field(ISTRUNCATED_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
        field(POLICIES_DESCRIPTOR)
        field(ROLEDETAILLIST_DESCRIPTOR)
        field(USERDETAILLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GROUPDETAILLIST_DESCRIPTOR.index -> builder.groupDetailList =
                    deserializer.deserializeList(GROUPDETAILLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ISTRUNCATED_DESCRIPTOR.index -> builder.isTruncated = deserializeBoolean()
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                POLICIES_DESCRIPTOR.index -> builder.policies =
                    deserializer.deserializeList(POLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ManagedPolicyDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeManagedPolicyDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROLEDETAILLIST_DESCRIPTOR.index -> builder.roleDetailList =
                    deserializer.deserializeList(ROLEDETAILLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<RoleDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRoleDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERDETAILLIST_DESCRIPTOR.index -> builder.userDetailList =
                    deserializer.deserializeList(USERDETAILLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<UserDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
