// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.serde

import aws.sdk.kotlin.services.iam.model.AddRoleToInstanceProfileResponse
import aws.sdk.kotlin.services.iam.model.IamException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddRoleToInstanceProfileOperationDeserializer: HttpDeserialize<AddRoleToInstanceProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AddRoleToInstanceProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddRoleToInstanceProfileError(context, call)
        }
        val builder = AddRoleToInstanceProfileResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAddRoleToInstanceProfileError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw IamException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnmodifiableEntity" -> UnmodifiableEntityExceptionDeserializer().deserialize(context, wrappedCall)
        "EntityAlreadyExists" -> EntityAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceeded" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NoSuchEntity" -> NoSuchEntityExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceFailure" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
