// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an X.509 signing certificate.
 *
 * This data type is used as a response element in the UploadSigningCertificate and ListSigningCertificates operations.
 */
public class SigningCertificate private constructor(builder: Builder) {
    /**
     * The contents of the signing certificate.
     */
    public val certificateBody: kotlin.String = requireNotNull(builder.certificateBody) { "A non-null value must be provided for certificateBody" }
    /**
     * The ID for the signing certificate.
     */
    public val certificateId: kotlin.String = requireNotNull(builder.certificateId) { "A non-null value must be provided for certificateId" }
    /**
     * The status of the signing certificate. `Active` means that the key is valid for API calls, while `Inactive` means it is not.
     */
    public val status: aws.sdk.kotlin.services.iam.model.StatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The date when the signing certificate was uploaded.
     */
    public val uploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.uploadDate
    /**
     * The name of the user the signing certificate is associated with.
     */
    public val userName: kotlin.String = requireNotNull(builder.userName) { "A non-null value must be provided for userName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.SigningCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SigningCertificate(")
        append("certificateBody=$certificateBody,")
        append("certificateId=$certificateId,")
        append("status=$status,")
        append("uploadDate=$uploadDate,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateBody.hashCode()
        result = 31 * result + (certificateId.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (uploadDate?.hashCode() ?: 0)
        result = 31 * result + (userName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SigningCertificate

        if (certificateBody != other.certificateBody) return false
        if (certificateId != other.certificateId) return false
        if (status != other.status) return false
        if (uploadDate != other.uploadDate) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.SigningCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The contents of the signing certificate.
         */
        public var certificateBody: kotlin.String? = null
        /**
         * The ID for the signing certificate.
         */
        public var certificateId: kotlin.String? = null
        /**
         * The status of the signing certificate. `Active` means that the key is valid for API calls, while `Inactive` means it is not.
         */
        public var status: aws.sdk.kotlin.services.iam.model.StatusType? = null
        /**
         * The date when the signing certificate was uploaded.
         */
        public var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the user the signing certificate is associated with.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.SigningCertificate) : this() {
            this.certificateBody = x.certificateBody
            this.certificateId = x.certificateId
            this.status = x.status
            this.uploadDate = x.uploadDate
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.SigningCertificate = SigningCertificate(this)

        internal fun correctErrors(): Builder {
            if (certificateBody == null) certificateBody = ""
            if (certificateId == null) certificateId = ""
            if (status == null) status = StatusType.SdkUnknown("no value provided")
            if (userName == null) userName = ""
            return this
        }
    }
}
