// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a server certificate without its certificate body, certificate chain, and private key.
 *
 *  This data type is used as a response element in the UploadServerCertificate and ListServerCertificates operations.
 */
public class ServerCertificateMetadata private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how to use them in policies, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date on which the certificate is set to expire.
     */
    public val expiration: aws.smithy.kotlin.runtime.time.Instant? = builder.expiration
    /**
     * The path to the server certificate. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val path: kotlin.String = requireNotNull(builder.path) { "A non-null value must be provided for path" }
    /**
     * The stable and unique string identifying the server certificate. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val serverCertificateId: kotlin.String = requireNotNull(builder.serverCertificateId) { "A non-null value must be provided for serverCertificateId" }
    /**
     * The name that identifies the server certificate.
     */
    public val serverCertificateName: kotlin.String = requireNotNull(builder.serverCertificateName) { "A non-null value must be provided for serverCertificateName" }
    /**
     * The date when the server certificate was uploaded.
     */
    public val uploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.uploadDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerCertificateMetadata(")
        append("arn=$arn,")
        append("expiration=$expiration,")
        append("path=$path,")
        append("serverCertificateId=$serverCertificateId,")
        append("serverCertificateName=$serverCertificateName,")
        append("uploadDate=$uploadDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (path.hashCode())
        result = 31 * result + (serverCertificateId.hashCode())
        result = 31 * result + (serverCertificateName.hashCode())
        result = 31 * result + (uploadDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerCertificateMetadata

        if (arn != other.arn) return false
        if (expiration != other.expiration) return false
        if (path != other.path) return false
        if (serverCertificateId != other.serverCertificateId) return false
        if (serverCertificateName != other.serverCertificateName) return false
        if (uploadDate != other.uploadDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) specifying the server certificate. For more information about ARNs and how to use them in policies, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var arn: kotlin.String? = null
        /**
         * The date on which the certificate is set to expire.
         */
        public var expiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the server certificate. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var path: kotlin.String? = null
        /**
         * The stable and unique string identifying the server certificate. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var serverCertificateId: kotlin.String? = null
        /**
         * The name that identifies the server certificate.
         */
        public var serverCertificateName: kotlin.String? = null
        /**
         * The date when the server certificate was uploaded.
         */
        public var uploadDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata) : this() {
            this.arn = x.arn
            this.expiration = x.expiration
            this.path = x.path
            this.serverCertificateId = x.serverCertificateId
            this.serverCertificateName = x.serverCertificateName
            this.uploadDate = x.uploadDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ServerCertificateMetadata = ServerCertificateMetadata(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (path == null) path = ""
            if (serverCertificateId == null) serverCertificateId = ""
            if (serverCertificateName == null) serverCertificateName = ""
            return this
        }
    }
}
