// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an IAM role, including all of the role's policies.
 *
 * This data type is used as a response element in the GetAccountAuthorizationDetails operation.
 */
public class RoleDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
     *
     * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The trust policy that grants permission to assume the role.
     */
    public val assumeRolePolicyDocument: kotlin.String? = builder.assumeRolePolicyDocument
    /**
     * A list of managed policies attached to the role. These policies are the role's access (permissions) policies.
     */
    public val attachedManagedPolicies: List<AttachedPolicy>? = builder.attachedManagedPolicies
    /**
     * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the role was created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * A list of instance profiles that contain this role.
     */
    public val instanceProfileList: List<InstanceProfile>? = builder.instanceProfileList
    /**
     * The path to the role. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The ARN of the policy used to set the permissions boundary for the role.
     *
     * For more information about permissions boundaries, see [Permissions boundaries for IAM identities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
     */
    public val permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = builder.permissionsBoundary
    /**
     * The stable and unique string identifying the role. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val roleId: kotlin.String? = builder.roleId
    /**
     * Contains information about the last time that an IAM role was used. This includes the date and time and the Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be shorter if your Region began supporting these features within the last year. The role might have been used more than 400 days ago. For more information, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period) in the *IAM User Guide*.
     */
    public val roleLastUsed: aws.sdk.kotlin.services.iam.model.RoleLastUsed? = builder.roleLastUsed
    /**
     * The friendly name that identifies the role.
     */
    public val roleName: kotlin.String? = builder.roleName
    /**
     * A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.
     */
    public val rolePolicyList: List<PolicyDetail>? = builder.rolePolicyList
    /**
     * A list of tags that are attached to the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.RoleDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleDetail(")
        append("arn=$arn,")
        append("assumeRolePolicyDocument=$assumeRolePolicyDocument,")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("instanceProfileList=$instanceProfileList,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("roleId=$roleId,")
        append("roleLastUsed=$roleLastUsed,")
        append("roleName=$roleName,")
        append("rolePolicyList=$rolePolicyList,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (assumeRolePolicyDocument?.hashCode() ?: 0)
        result = 31 * result + (attachedManagedPolicies?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileList?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (roleId?.hashCode() ?: 0)
        result = 31 * result + (roleLastUsed?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (rolePolicyList?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleDetail

        if (arn != other.arn) return false
        if (assumeRolePolicyDocument != other.assumeRolePolicyDocument) return false
        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (instanceProfileList != other.instanceProfileList) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (roleId != other.roleId) return false
        if (roleLastUsed != other.roleLastUsed) return false
        if (roleName != other.roleName) return false
        if (rolePolicyList != other.rolePolicyList) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.RoleDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.
         *
         * For more information about ARNs, go to [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The trust policy that grants permission to assume the role.
         */
        public var assumeRolePolicyDocument: kotlin.String? = null
        /**
         * A list of managed policies attached to the role. These policies are the role's access (permissions) policies.
         */
        public var attachedManagedPolicies: List<AttachedPolicy>? = null
        /**
         * The date and time, in [ISO 8601 date-time format](http://www.iso.org/iso/iso8601), when the role was created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of instance profiles that contain this role.
         */
        public var instanceProfileList: List<InstanceProfile>? = null
        /**
         * The path to the role. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var path: kotlin.String? = null
        /**
         * The ARN of the policy used to set the permissions boundary for the role.
         *
         * For more information about permissions boundaries, see [Permissions boundaries for IAM identities ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
         */
        public var permissionsBoundary: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary? = null
        /**
         * The stable and unique string identifying the role. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var roleId: kotlin.String? = null
        /**
         * Contains information about the last time that an IAM role was used. This includes the date and time and the Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be shorter if your Region began supporting these features within the last year. The role might have been used more than 400 days ago. For more information, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period) in the *IAM User Guide*.
         */
        public var roleLastUsed: aws.sdk.kotlin.services.iam.model.RoleLastUsed? = null
        /**
         * The friendly name that identifies the role.
         */
        public var roleName: kotlin.String? = null
        /**
         * A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.
         */
        public var rolePolicyList: List<PolicyDetail>? = null
        /**
         * A list of tags that are attached to the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.RoleDetail) : this() {
            this.arn = x.arn
            this.assumeRolePolicyDocument = x.assumeRolePolicyDocument
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.instanceProfileList = x.instanceProfileList
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.roleId = x.roleId
            this.roleLastUsed = x.roleLastUsed
            this.roleName = x.roleName
            this.rolePolicyList = x.rolePolicyList
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.RoleDetail = RoleDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary] inside the given [block]
         */
        public fun permissionsBoundary(block: aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.iam.model.AttachedPermissionsBoundary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iam.model.RoleLastUsed] inside the given [block]
         */
        public fun roleLastUsed(block: aws.sdk.kotlin.services.iam.model.RoleLastUsed.Builder.() -> kotlin.Unit) {
            this.roleLastUsed = aws.sdk.kotlin.services.iam.model.RoleLastUsed.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
