// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about a user that a managed policy is attached to.
 *
 * This data type is used as a response element in the ListEntitiesForPolicy operation.
 *
 * For more information about managed policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public class PolicyUser private constructor(builder: Builder) {
    /**
     * The stable and unique string identifying the user. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
     */
    public val userId: kotlin.String? = builder.userId
    /**
     * The name (friendly name, not ARN) identifying the user.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PolicyUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyUser(")
        append("userId=$userId,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = userId?.hashCode() ?: 0
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyUser

        if (userId != other.userId) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PolicyUser = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The stable and unique string identifying the user. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
         */
        public var userId: kotlin.String? = null
        /**
         * The name (friendly name, not ARN) identifying the user.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PolicyUser) : this() {
            this.userId = x.userId
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PolicyUser = PolicyUser(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
