// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about a role that a managed policy is attached to.
 *
 * This data type is used as a response element in the ListEntitiesForPolicy operation.
 *
 * For more information about managed policies, refer to [Managed policies and inline policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *IAM User Guide*.
 */
public class PolicyRole private constructor(builder: Builder) {
    /**
     * The stable and unique string identifying the role. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
     */
    public val roleId: kotlin.String? = builder.roleId
    /**
     * The name (friendly name, not ARN) identifying the role.
     */
    public val roleName: kotlin.String? = builder.roleName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PolicyRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyRole(")
        append("roleId=$roleId,")
        append("roleName=$roleName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleId?.hashCode() ?: 0
        result = 31 * result + (roleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyRole

        if (roleId != other.roleId) return false
        if (roleName != other.roleName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PolicyRole = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The stable and unique string identifying the role. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
         */
        public var roleId: kotlin.String? = null
        /**
         * The name (friendly name, not ARN) identifying the role.
         */
        public var roleName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PolicyRole) : this() {
            this.roleId = x.roleId
            this.roleName = x.roleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PolicyRole = PolicyRole(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
