// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about the account password policy.
 *
 *  This data type is used as a response element in the GetAccountPasswordPolicy operation.
 */
public class PasswordPolicy private constructor(builder: Builder) {
    /**
     * Specifies whether IAM users are allowed to change their own password. Gives IAM users permissions to `iam:ChangePassword` for only their user and to the `iam:GetAccountPasswordPolicy` action. This option does not attach a permissions policy to each user, rather the permissions are applied at the account-level for all users by IAM.
     */
    public val allowUsersToChangePassword: kotlin.Boolean = builder.allowUsersToChangePassword
    /**
     * Indicates whether passwords in the account expire. Returns true if `MaxPasswordAge` contains a value greater than 0. Returns false if MaxPasswordAge is 0 or not present.
     */
    public val expirePasswords: kotlin.Boolean = builder.expirePasswords
    /**
     * Specifies whether IAM users are prevented from setting a new password via the Amazon Web Services Management Console after their password has expired. The IAM user cannot access the console until an administrator resets the password. IAM users with `iam:ChangePassword` permission and active access keys can reset their own expired console password using the CLI or API.
     */
    public val hardExpiry: kotlin.Boolean? = builder.hardExpiry
    /**
     * The number of days that an IAM user password is valid.
     */
    public val maxPasswordAge: kotlin.Int? = builder.maxPasswordAge
    /**
     * Minimum length to require for IAM user passwords.
     */
    public val minimumPasswordLength: kotlin.Int? = builder.minimumPasswordLength
    /**
     * Specifies the number of previous passwords that IAM users are prevented from reusing.
     */
    public val passwordReusePrevention: kotlin.Int? = builder.passwordReusePrevention
    /**
     * Specifies whether IAM user passwords must contain at least one lowercase character (a to z).
     */
    public val requireLowercaseCharacters: kotlin.Boolean = builder.requireLowercaseCharacters
    /**
     * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
     */
    public val requireNumbers: kotlin.Boolean = builder.requireNumbers
    /**
     * Specifies whether IAM user passwords must contain at least one of the following symbols:
     *
     * ! @ # $ % ^ & * ( ) _ + - = &#91; &#93; { } | '
     */
    public val requireSymbols: kotlin.Boolean = builder.requireSymbols
    /**
     * Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).
     */
    public val requireUppercaseCharacters: kotlin.Boolean = builder.requireUppercaseCharacters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.PasswordPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PasswordPolicy(")
        append("allowUsersToChangePassword=$allowUsersToChangePassword,")
        append("expirePasswords=$expirePasswords,")
        append("hardExpiry=$hardExpiry,")
        append("maxPasswordAge=$maxPasswordAge,")
        append("minimumPasswordLength=$minimumPasswordLength,")
        append("passwordReusePrevention=$passwordReusePrevention,")
        append("requireLowercaseCharacters=$requireLowercaseCharacters,")
        append("requireNumbers=$requireNumbers,")
        append("requireSymbols=$requireSymbols,")
        append("requireUppercaseCharacters=$requireUppercaseCharacters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowUsersToChangePassword.hashCode()
        result = 31 * result + (expirePasswords.hashCode())
        result = 31 * result + (hardExpiry?.hashCode() ?: 0)
        result = 31 * result + (maxPasswordAge ?: 0)
        result = 31 * result + (minimumPasswordLength ?: 0)
        result = 31 * result + (passwordReusePrevention ?: 0)
        result = 31 * result + (requireLowercaseCharacters.hashCode())
        result = 31 * result + (requireNumbers.hashCode())
        result = 31 * result + (requireSymbols.hashCode())
        result = 31 * result + (requireUppercaseCharacters.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PasswordPolicy

        if (allowUsersToChangePassword != other.allowUsersToChangePassword) return false
        if (expirePasswords != other.expirePasswords) return false
        if (hardExpiry != other.hardExpiry) return false
        if (maxPasswordAge != other.maxPasswordAge) return false
        if (minimumPasswordLength != other.minimumPasswordLength) return false
        if (passwordReusePrevention != other.passwordReusePrevention) return false
        if (requireLowercaseCharacters != other.requireLowercaseCharacters) return false
        if (requireNumbers != other.requireNumbers) return false
        if (requireSymbols != other.requireSymbols) return false
        if (requireUppercaseCharacters != other.requireUppercaseCharacters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.PasswordPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether IAM users are allowed to change their own password. Gives IAM users permissions to `iam:ChangePassword` for only their user and to the `iam:GetAccountPasswordPolicy` action. This option does not attach a permissions policy to each user, rather the permissions are applied at the account-level for all users by IAM.
         */
        public var allowUsersToChangePassword: kotlin.Boolean = false
        /**
         * Indicates whether passwords in the account expire. Returns true if `MaxPasswordAge` contains a value greater than 0. Returns false if MaxPasswordAge is 0 or not present.
         */
        public var expirePasswords: kotlin.Boolean = false
        /**
         * Specifies whether IAM users are prevented from setting a new password via the Amazon Web Services Management Console after their password has expired. The IAM user cannot access the console until an administrator resets the password. IAM users with `iam:ChangePassword` permission and active access keys can reset their own expired console password using the CLI or API.
         */
        public var hardExpiry: kotlin.Boolean? = null
        /**
         * The number of days that an IAM user password is valid.
         */
        public var maxPasswordAge: kotlin.Int? = null
        /**
         * Minimum length to require for IAM user passwords.
         */
        public var minimumPasswordLength: kotlin.Int? = null
        /**
         * Specifies the number of previous passwords that IAM users are prevented from reusing.
         */
        public var passwordReusePrevention: kotlin.Int? = null
        /**
         * Specifies whether IAM user passwords must contain at least one lowercase character (a to z).
         */
        public var requireLowercaseCharacters: kotlin.Boolean = false
        /**
         * Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).
         */
        public var requireNumbers: kotlin.Boolean = false
        /**
         * Specifies whether IAM user passwords must contain at least one of the following symbols:
         *
         * ! @ # $ % ^ & * ( ) _ + - = &#91; &#93; { } | '
         */
        public var requireSymbols: kotlin.Boolean = false
        /**
         * Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).
         */
        public var requireUppercaseCharacters: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.PasswordPolicy) : this() {
            this.allowUsersToChangePassword = x.allowUsersToChangePassword
            this.expirePasswords = x.expirePasswords
            this.hardExpiry = x.hardExpiry
            this.maxPasswordAge = x.maxPasswordAge
            this.minimumPasswordLength = x.minimumPasswordLength
            this.passwordReusePrevention = x.passwordReusePrevention
            this.requireLowercaseCharacters = x.requireLowercaseCharacters
            this.requireNumbers = x.requireNumbers
            this.requireSymbols = x.requireSymbols
            this.requireUppercaseCharacters = x.requireUppercaseCharacters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.PasswordPolicy = PasswordPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
