// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains the response to a successful ListPolicyVersions request.
 */
public class ListPolicyVersionsResponse private constructor(builder: Builder) {
    /**
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the `Marker` request parameter to retrieve more items. Note that IAM might return fewer than the `MaxItems` number of results even when there are more results available. We recommend that you check `IsTruncated` after every call to ensure that you receive all your results.
     */
    public val isTruncated: kotlin.Boolean = builder.isTruncated
    /**
     * When `IsTruncated` is `true`, this element is present and contains the value to use for the `Marker` parameter in a subsequent pagination request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * A list of policy versions.
     *
     * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
     */
    public val versions: List<PolicyVersion>? = builder.versions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ListPolicyVersionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPolicyVersionsResponse(")
        append("isTruncated=$isTruncated,")
        append("marker=$marker,")
        append("versions=$versions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPolicyVersionsResponse

        if (isTruncated != other.isTruncated) return false
        if (marker != other.marker) return false
        if (versions != other.versions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ListPolicyVersionsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the `Marker` request parameter to retrieve more items. Note that IAM might return fewer than the `MaxItems` number of results even when there are more results available. We recommend that you check `IsTruncated` after every call to ensure that you receive all your results.
         */
        public var isTruncated: kotlin.Boolean = false
        /**
         * When `IsTruncated` is `true`, this element is present and contains the value to use for the `Marker` parameter in a subsequent pagination request.
         */
        public var marker: kotlin.String? = null
        /**
         * A list of policy versions.
         *
         * For more information about managed policy versions, see [Versioning for managed policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html) in the *IAM User Guide*.
         */
        public var versions: List<PolicyVersion>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ListPolicyVersionsResponse) : this() {
            this.isTruncated = x.isTruncated
            this.marker = x.marker
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ListPolicyVersionsResponse = ListPolicyVersionsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
