// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



public class ListOpenIdConnectProviderTagsRequest private constructor(builder: Builder) {
    /**
     * Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the `Marker` element in the response that you received to indicate where the next call should start.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the `IsTruncated` response element is `true`.
     *
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the `IsTruncated` response element returns `true`, and `Marker` contains a value to include in the subsequent call that tells the service where to continue from.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to see.
     *
     * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
     */
    public val openIdConnectProviderArn: kotlin.String? = builder.openIdConnectProviderArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProviderTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListOpenIdConnectProviderTagsRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("openIdConnectProviderArn=$openIdConnectProviderArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (openIdConnectProviderArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListOpenIdConnectProviderTagsRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (openIdConnectProviderArn != other.openIdConnectProviderArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProviderTagsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the `Marker` element in the response that you received to indicate where the next call should start.
         */
        public var marker: kotlin.String? = null
        /**
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the `IsTruncated` response element is `true`.
         *
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the `IsTruncated` response element returns `true`, and `Marker` contains a value to include in the subsequent call that tells the service where to continue from.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to see.
         *
         * This parameter allows (through its [regex pattern](http://wikipedia.org/wiki/regex)) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-
         */
        public var openIdConnectProviderArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProviderTagsRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.openIdConnectProviderArn = x.openIdConnectProviderArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ListOpenIdConnectProviderTagsRequest = ListOpenIdConnectProviderTagsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
