// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an instance profile.
 *
 * This data type is used as a response element in the following operations:
 * + CreateInstanceProfile
 * + GetInstanceProfile
 * + ListInstanceProfiles
 * + ListInstanceProfilesForRole
 */
public class InstanceProfile private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) specifying the instance profile. For more information about ARNs and how to use them in policies, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date when the instance profile was created.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createDate) { "A non-null value must be provided for createDate" }
    /**
     * The stable and unique string identifying the instance profile. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val instanceProfileId: kotlin.String = requireNotNull(builder.instanceProfileId) { "A non-null value must be provided for instanceProfileId" }
    /**
     * The name identifying the instance profile.
     */
    public val instanceProfileName: kotlin.String = requireNotNull(builder.instanceProfileName) { "A non-null value must be provided for instanceProfileName" }
    /**
     * The path to the instance profile. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
     */
    public val path: kotlin.String = requireNotNull(builder.path) { "A non-null value must be provided for path" }
    /**
     * The role associated with the instance profile.
     */
    public val roles: List<Role> = requireNotNull(builder.roles) { "A non-null value must be provided for roles" }
    /**
     * A list of tags that are attached to the instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.InstanceProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceProfile(")
        append("arn=$arn,")
        append("createDate=$createDate,")
        append("instanceProfileId=$instanceProfileId,")
        append("instanceProfileName=$instanceProfileName,")
        append("path=$path,")
        append("roles=$roles,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createDate.hashCode())
        result = 31 * result + (instanceProfileId.hashCode())
        result = 31 * result + (instanceProfileName.hashCode())
        result = 31 * result + (path.hashCode())
        result = 31 * result + (roles.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceProfile

        if (arn != other.arn) return false
        if (createDate != other.createDate) return false
        if (instanceProfileId != other.instanceProfileId) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (path != other.path) return false
        if (roles != other.roles) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.InstanceProfile = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) specifying the instance profile. For more information about ARNs and how to use them in policies, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the instance profile was created.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The stable and unique string identifying the instance profile. For more information about IDs, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var instanceProfileId: kotlin.String? = null
        /**
         * The name identifying the instance profile.
         */
        public var instanceProfileName: kotlin.String? = null
        /**
         * The path to the instance profile. For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the *IAM User Guide*.
         */
        public var path: kotlin.String? = null
        /**
         * The role associated with the instance profile.
         */
        public var roles: List<Role>? = null
        /**
         * A list of tags that are attached to the instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.InstanceProfile) : this() {
            this.arn = x.arn
            this.createDate = x.createDate
            this.instanceProfileId = x.instanceProfileId
            this.instanceProfileName = x.instanceProfileName
            this.path = x.path
            this.roles = x.roles
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.InstanceProfile = InstanceProfile(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createDate == null) createDate = Instant.fromEpochSeconds(0)
            if (instanceProfileId == null) instanceProfileId = ""
            if (instanceProfileName == null) instanceProfileName = ""
            if (path == null) path = ""
            if (roles == null) roles = emptyList()
            return this
        }
    }
}
