// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMfaDeviceResponse private constructor(builder: Builder) {
    /**
     * The certifications of a specified user's MFA device. We currently provide FIPS-140-2, FIPS-140-3, and FIDO certification levels obtained from [ FIDO Alliance Metadata Service (MDS)](https://fidoalliance.org/metadata/).
     */
    public val certifications: Map<String, String>? = builder.certifications
    /**
     * The date that a specified user's MFA device was first enabled.
     */
    public val enableDate: aws.smithy.kotlin.runtime.time.Instant? = builder.enableDate
    /**
     * Serial number that uniquely identifies the MFA device. For this API, we only accept FIDO security key [ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
     */
    public val serialNumber: kotlin.String = requireNotNull(builder.serialNumber) { "A non-null value must be provided for serialNumber" }
    /**
     * The friendly name identifying the user.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.GetMfaDeviceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMfaDeviceResponse(")
        append("certifications=$certifications,")
        append("enableDate=$enableDate,")
        append("serialNumber=$serialNumber,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certifications?.hashCode() ?: 0
        result = 31 * result + (enableDate?.hashCode() ?: 0)
        result = 31 * result + (serialNumber.hashCode())
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMfaDeviceResponse

        if (certifications != other.certifications) return false
        if (enableDate != other.enableDate) return false
        if (serialNumber != other.serialNumber) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.GetMfaDeviceResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The certifications of a specified user's MFA device. We currently provide FIPS-140-2, FIPS-140-3, and FIDO certification levels obtained from [ FIDO Alliance Metadata Service (MDS)](https://fidoalliance.org/metadata/).
         */
        public var certifications: Map<String, String>? = null
        /**
         * The date that a specified user's MFA device was first enabled.
         */
        public var enableDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Serial number that uniquely identifies the MFA device. For this API, we only accept FIDO security key [ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
         */
        public var serialNumber: kotlin.String? = null
        /**
         * The friendly name identifying the user.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.GetMfaDeviceResponse) : this() {
            this.certifications = x.certifications
            this.enableDate = x.enableDate
            this.serialNumber = x.serialNumber
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.GetMfaDeviceResponse = GetMfaDeviceResponse(this)

        internal fun correctErrors(): Builder {
            if (serialNumber == null) serialNumber = ""
            return this
        }
    }
}
