// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.model



/**
 * Contains information about a condition context key. It includes the name of the key and specifies the value (or values, if the context key supports multiple values) to use in the simulation. This information is used when evaluating the `Condition` elements of the input policies.
 *
 * This data type is used as an input parameter to SimulateCustomPolicy and SimulatePrincipalPolicy.
 */
public class ContextEntry private constructor(builder: Builder) {
    /**
     * The full name of a condition context key, including the service prefix. For example, `aws:SourceIp` or `s3:VersionId`.
     */
    public val contextKeyName: kotlin.String? = builder.contextKeyName
    /**
     * The data type of the value (or values) specified in the `ContextKeyValues` parameter.
     */
    public val contextKeyType: aws.sdk.kotlin.services.iam.model.ContextKeyTypeEnum? = builder.contextKeyType
    /**
     * The value (or values, if the condition context key supports multiple values) to provide to the simulation when the key is referenced by a `Condition` element in an input policy.
     */
    public val contextKeyValues: List<String>? = builder.contextKeyValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iam.model.ContextEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContextEntry(")
        append("contextKeyName=$contextKeyName,")
        append("contextKeyType=$contextKeyType,")
        append("contextKeyValues=$contextKeyValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contextKeyName?.hashCode() ?: 0
        result = 31 * result + (contextKeyType?.hashCode() ?: 0)
        result = 31 * result + (contextKeyValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContextEntry

        if (contextKeyName != other.contextKeyName) return false
        if (contextKeyType != other.contextKeyType) return false
        if (contextKeyValues != other.contextKeyValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iam.model.ContextEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full name of a condition context key, including the service prefix. For example, `aws:SourceIp` or `s3:VersionId`.
         */
        public var contextKeyName: kotlin.String? = null
        /**
         * The data type of the value (or values) specified in the `ContextKeyValues` parameter.
         */
        public var contextKeyType: aws.sdk.kotlin.services.iam.model.ContextKeyTypeEnum? = null
        /**
         * The value (or values, if the condition context key supports multiple values) to provide to the simulation when the key is referenced by a `Condition` element in an input policy.
         */
        public var contextKeyValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iam.model.ContextEntry) : this() {
            this.contextKeyName = x.contextKeyName
            this.contextKeyType = x.contextKeyType
            this.contextKeyValues = x.contextKeyValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iam.model.ContextEntry = ContextEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
