// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iam.endpoints.internal

import aws.sdk.kotlin.services.iam.IamClient
import aws.sdk.kotlin.services.iam.endpoints.IamEndpointParameters
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: IamClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: IamClient.Config, request: ResolveEndpointRequest): IamEndpointParameters {
    return IamEndpointParameters {
        bindAwsBuiltins(config, request)
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (IamEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun IamEndpointParameters.Builder.bindAwsBuiltins(config: IamClient.Config, request: ResolveEndpointRequest) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
