// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.serde

import aws.sdk.kotlin.services.honeycode.model.BatchUpdateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.UpdateRowData
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class BatchUpdateTableRowsOperationSerializer: HttpSerialize<BatchUpdateTableRowsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchUpdateTableRowsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.workbookId) { "workbookId is bound to the URI and must not be null" }
            requireNotNull(input.tableId) { "tableId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("workbooks"))
                add(PercentEncoding.SmithyLabel.encode("${input.workbookId}"))
                add(PercentEncoding.Path.encode("tables"))
                add(PercentEncoding.SmithyLabel.encode("${input.tableId}"))
                add(PercentEncoding.Path.encode("rows"))
                add(PercentEncoding.Path.encode("batchupdate"))
            }
        }

        val payload = serializeBatchUpdateTableRowsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchUpdateTableRowsOperationBody(context: ExecutionContext, input: BatchUpdateTableRowsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val ROWSTOUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rowsToUpdate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ROWSTOUPDATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        if (input.rowsToUpdate != null) {
            listField(ROWSTOUPDATE_DESCRIPTOR) {
                for (el0 in input.rowsToUpdate) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeUpdateRowDataDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
