// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.paginators

import aws.sdk.kotlin.services.honeycode.HoneycodeClient
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTablesRequest
import aws.sdk.kotlin.services.honeycode.model.ListTablesResponse
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.Table
import aws.sdk.kotlin.services.honeycode.model.TableColumn
import aws.sdk.kotlin.services.honeycode.model.TableRow
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListTableColumnsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTableColumnsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableColumnsResponse]
 */
public fun HoneycodeClient.listTableColumnsPaginated(initialRequest: ListTableColumnsRequest): Flow<ListTableColumnsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTableColumnsPaginated.listTableColumns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTableColumnsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableColumnsResponse]
 */
public fun HoneycodeClient.listTableColumnsPaginated(block: ListTableColumnsRequest.Builder.() -> Unit): Flow<ListTableColumnsResponse> =
    listTableColumnsPaginated(ListTableColumnsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTableColumnsPaginated]
 * to access the nested member [TableColumn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableColumn]
 */
@JvmName("listTableColumnsResponseTableColumn")
public fun Flow<ListTableColumnsResponse>.tableColumns(): Flow<TableColumn> =
    transform() { response ->
        response.tableColumns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTableRowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableRowsResponse]
 */
public fun HoneycodeClient.listTableRowsPaginated(initialRequest: ListTableRowsRequest): Flow<ListTableRowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTableRowsPaginated.listTableRows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTableRowsResponse]
 */
public fun HoneycodeClient.listTableRowsPaginated(block: ListTableRowsRequest.Builder.() -> Unit): Flow<ListTableRowsResponse> =
    listTableRowsPaginated(ListTableRowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTableRowsPaginated]
 * to access the nested member [TableRow]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableRow]
 */
@JvmName("listTableRowsResponseTableRow")
public fun Flow<ListTableRowsResponse>.rows(): Flow<TableRow> =
    transform() { response ->
        response.rows?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTablesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
public fun HoneycodeClient.listTablesPaginated(initialRequest: ListTablesRequest): Flow<ListTablesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTablesPaginated.listTables(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
public fun HoneycodeClient.listTablesPaginated(block: ListTablesRequest.Builder.() -> Unit): Flow<ListTablesResponse> =
    listTablesPaginated(ListTablesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTablesPaginated]
 * to access the nested member [Table]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Table]
 */
@JvmName("listTablesResponseTable")
public fun Flow<ListTablesResponse>.tables(): Flow<Table> =
    transform() { response ->
        response.tables?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [QueryTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [QueryTableRowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryTableRowsResponse]
 */
public fun HoneycodeClient.queryTableRowsPaginated(initialRequest: QueryTableRowsRequest): Flow<QueryTableRowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@queryTableRowsPaginated.queryTableRows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [QueryTableRowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryTableRowsResponse]
 */
public fun HoneycodeClient.queryTableRowsPaginated(block: QueryTableRowsRequest.Builder.() -> Unit): Flow<QueryTableRowsResponse> =
    queryTableRowsPaginated(QueryTableRowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [queryTableRowsPaginated]
 * to access the nested member [TableRow]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableRow]
 */
@JvmName("queryTableRowsResponseTableRow")
public fun Flow<QueryTableRowsResponse>.rows(): Flow<TableRow> =
    transform() { response ->
        response.rows?.forEach {
            emit(it)
        }
    }
