// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



/**
 * ResultSet contains the results of the request for a single block or list defined on the screen.
 */
public class ResultSet private constructor(builder: Builder) {
    /**
     * List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used.
     *
     *  For example, a task list that displays the task name, due date and assigned person might have headers &#91; { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} &#93;. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element.
     */
    public val headers: List<ColumnMetadata> = requireNotNull(builder.headers) { "A non-null value must be provided for headers" }
    /**
     * List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header.
     */
    public val rows: List<ResultRow> = requireNotNull(builder.rows) { "A non-null value must be provided for rows" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.ResultSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResultSet(")
        append("headers=$headers,")
        append("rows=$rows")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers.hashCode()
        result = 31 * result + (rows.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResultSet

        if (headers != other.headers) return false
        if (rows != other.rows) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.ResultSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used.
         *
         *  For example, a task list that displays the task name, due date and assigned person might have headers &#91; { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} &#93;. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element.
         */
        public var headers: List<ColumnMetadata>? = null
        /**
         * List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header.
         */
        public var rows: List<ResultRow>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.ResultSet) : this() {
            this.headers = x.headers
            this.rows = x.rows
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.ResultSet = ResultSet(this)

        internal fun correctErrors(): Builder {
            if (headers == null) headers = emptyList()
            if (rows == null) rows = emptyList()
            return this
        }
    }
}
