// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



/**
 * Data needed to create a single row in a table as part of the BatchCreateTableRows request.
 */
public class CreateRowData private constructor(builder: Builder) {
    /**
     * An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results.
     */
    public val batchItemId: kotlin.String = requireNotNull(builder.batchItemId) { "A non-null value must be provided for batchItemId" }
    /**
     * A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell.
     */
    public val cellsToCreate: Map<String, CellInput> = requireNotNull(builder.cellsToCreate) { "A non-null value must be provided for cellsToCreate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.CreateRowData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRowData(")
        append("batchItemId=$batchItemId,")
        append("cellsToCreate=$cellsToCreate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchItemId.hashCode()
        result = 31 * result + (cellsToCreate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRowData

        if (batchItemId != other.batchItemId) return false
        if (cellsToCreate != other.cellsToCreate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.CreateRowData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results.
         */
        public var batchItemId: kotlin.String? = null
        /**
         * A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell.
         */
        public var cellsToCreate: Map<String, CellInput>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.CreateRowData) : this() {
            this.batchItemId = x.batchItemId
            this.cellsToCreate = x.cellsToCreate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.CreateRowData = CreateRowData(this)

        internal fun correctErrors(): Builder {
            if (batchItemId == null) batchItemId = ""
            if (cellsToCreate == null) cellsToCreate = emptyMap()
            return this
        }
    }
}
