// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



public class BatchUpsertTableRowsRequest private constructor(builder: Builder) {
    /**
     * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.
     *
     *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list.
     *
     *  Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table.
     */
    public val rowsToUpsert: List<UpsertRowData>? = builder.rowsToUpsert
    /**
     * The ID of the table where the rows are being upserted.
     *
     *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public val tableId: kotlin.String? = builder.tableId
    /**
     * The ID of the workbook where the rows are being upserted.
     *
     *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public val workbookId: kotlin.String? = builder.workbookId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchUpsertTableRowsRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("rowsToUpsert=$rowsToUpsert,")
        append("tableId=$tableId,")
        append("workbookId=$workbookId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (rowsToUpsert?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchUpsertTableRowsRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (rowsToUpsert != other.rowsToUpsert) return false
        if (tableId != other.tableId) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.
         *
         *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list.
         *
         *  Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table.
         */
        public var rowsToUpsert: List<UpsertRowData>? = null
        /**
         * The ID of the table where the rows are being upserted.
         *
         *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        public var tableId: kotlin.String? = null
        /**
         * The ID of the workbook where the rows are being upserted.
         *
         *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        public var workbookId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.rowsToUpsert = x.rowsToUpsert
            this.tableId = x.tableId
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsRequest = BatchUpsertTableRowsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
