// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.honeycode.auth.DefaultHoneycodeAuthSchemeProvider
import aws.sdk.kotlin.services.honeycode.auth.HoneycodeAuthSchemeProvider
import aws.sdk.kotlin.services.honeycode.endpoints.DefaultHoneycodeEndpointProvider
import aws.sdk.kotlin.services.honeycode.endpoints.HoneycodeEndpointParameters
import aws.sdk.kotlin.services.honeycode.endpoints.HoneycodeEndpointProvider
import aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.BatchUpdateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchUpdateTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.DescribeTableDataImportJobRequest
import aws.sdk.kotlin.services.honeycode.model.DescribeTableDataImportJobResponse
import aws.sdk.kotlin.services.honeycode.model.GetScreenDataRequest
import aws.sdk.kotlin.services.honeycode.model.GetScreenDataResponse
import aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationRequest
import aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationResponse
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTablesRequest
import aws.sdk.kotlin.services.honeycode.model.ListTablesResponse
import aws.sdk.kotlin.services.honeycode.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.honeycode.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest
import aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobResponse
import aws.sdk.kotlin.services.honeycode.model.TagResourceRequest
import aws.sdk.kotlin.services.honeycode.model.TagResourceResponse
import aws.sdk.kotlin.services.honeycode.model.UntagResourceRequest
import aws.sdk.kotlin.services.honeycode.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Honeycode"
public const val SdkVersion: String = "1.0.39"
public const val ServiceApiVersion: String = "2020-03-01"

/**
 * Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals, resources, and even your team.
 */
public interface HoneycodeClient : SdkClient {
    /**
     * HoneycodeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, HoneycodeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Honeycode",
                "HONEYCODE",
                "honeycode",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, HoneycodeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): HoneycodeClient = DefaultHoneycodeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: HoneycodeEndpointProvider = builder.endpointProvider ?: DefaultHoneycodeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: HoneycodeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultHoneycodeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Honeycode"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: HoneycodeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: HoneycodeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API allows you to specify the values to set in some or all of the columns in the new rows.
     *
     *  If a column is not explicitly set in a specific row, then the column level formula specified in the table will be applied to the new row. If there is no column level formula but the last row of the table has a formula, then that formula will be copied down to the new row. If there is no column level formula and no formula in the last row of the table, then that column will be left blank for the new rows.
     */
    public suspend fun batchCreateTableRows(input: BatchCreateTableRowsRequest): BatchCreateTableRowsResponse

    /**
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table.
     */
    public suspend fun batchDeleteTableRows(input: BatchDeleteTableRowsRequest): BatchDeleteTableRowsResponse

    /**
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     *
     *  You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     */
    public suspend fun batchUpdateTableRows(input: BatchUpdateTableRowsRequest): BatchUpdateTableRowsResponse

    /**
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are found, it will update the cells in the matching rows to new values specified in the request. If no matching rows are found, a new row is added at the end of the table and the cells in that row are set to the new values specified in the request.
     *
     *  You can specify the values to set in some or all of the columns in the table for the matching or newly appended rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     */
    public suspend fun batchUpsertTableRows(input: BatchUpsertTableRowsRequest): BatchUpsertTableRowsResponse

    /**
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     */
    public suspend fun describeTableDataImportJob(input: DescribeTableDataImportJobRequest): DescribeTableDataImportJobResponse

    /**
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     */
    public suspend fun getScreenData(input: GetScreenDataRequest): GetScreenDataResponse

    /**
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook.
     */
    public suspend fun invokeScreenAutomation(input: InvokeScreenAutomationRequest): InvokeScreenAutomationResponse

    /**
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     */
    public suspend fun listTableColumns(input: ListTableColumnsRequest): ListTableColumnsResponse

    /**
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     */
    public suspend fun listTableRows(input: ListTableRowsRequest): ListTableRowsResponse

    /**
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     */
    public suspend fun listTables(input: ListTablesRequest): ListTablesResponse

    /**
     * The ListTagsForResource API allows you to return a resource's tags.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     */
    public suspend fun queryTableRows(input: QueryTableRowsRequest): QueryTableRowsResponse

    /**
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API.
     */
    public suspend fun startTableDataImportJob(input: StartTableDataImportJobRequest): StartTableDataImportJobResponse

    /**
     * The TagResource API allows you to add tags to an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The UntagResource API allows you to removes tags from an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun HoneycodeClient.withConfig(block: HoneycodeClient.Config.Builder.() -> Unit): HoneycodeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultHoneycodeClient(newConfig)
}

/**
 * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API allows you to specify the values to set in some or all of the columns in the new rows.
 *
 *  If a column is not explicitly set in a specific row, then the column level formula specified in the table will be applied to the new row. If there is no column level formula but the last row of the table has a formula, then that formula will be copied down to the new row. If there is no column level formula and no formula in the last row of the table, then that column will be left blank for the new rows.
 */
public suspend inline fun HoneycodeClient.batchCreateTableRows(crossinline block: BatchCreateTableRowsRequest.Builder.() -> Unit): BatchCreateTableRowsResponse = batchCreateTableRows(BatchCreateTableRowsRequest.Builder().apply(block).build())

/**
 * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table.
 */
public suspend inline fun HoneycodeClient.batchDeleteTableRows(crossinline block: BatchDeleteTableRowsRequest.Builder.() -> Unit): BatchDeleteTableRowsResponse = batchDeleteTableRows(BatchDeleteTableRowsRequest.Builder().apply(block).build())

/**
 * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
 *
 *  You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
 */
public suspend inline fun HoneycodeClient.batchUpdateTableRows(crossinline block: BatchUpdateTableRowsRequest.Builder.() -> Unit): BatchUpdateTableRowsResponse = batchUpdateTableRows(BatchUpdateTableRowsRequest.Builder().apply(block).build())

/**
 * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are found, it will update the cells in the matching rows to new values specified in the request. If no matching rows are found, a new row is added at the end of the table and the cells in that row are set to the new values specified in the request.
 *
 *  You can specify the values to set in some or all of the columns in the table for the matching or newly appended rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
 */
public suspend inline fun HoneycodeClient.batchUpsertTableRows(crossinline block: BatchUpsertTableRowsRequest.Builder.() -> Unit): BatchUpsertTableRowsResponse = batchUpsertTableRows(BatchUpsertTableRowsRequest.Builder().apply(block).build())

/**
 * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
 */
public suspend inline fun HoneycodeClient.describeTableDataImportJob(crossinline block: DescribeTableDataImportJobRequest.Builder.() -> Unit): DescribeTableDataImportJobResponse = describeTableDataImportJob(DescribeTableDataImportJobRequest.Builder().apply(block).build())

/**
 * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
 */
public suspend inline fun HoneycodeClient.getScreenData(crossinline block: GetScreenDataRequest.Builder.() -> Unit): GetScreenDataResponse = getScreenData(GetScreenDataRequest.Builder().apply(block).build())

/**
 * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook.
 */
public suspend inline fun HoneycodeClient.invokeScreenAutomation(crossinline block: InvokeScreenAutomationRequest.Builder.() -> Unit): InvokeScreenAutomationResponse = invokeScreenAutomation(InvokeScreenAutomationRequest.Builder().apply(block).build())

/**
 * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
 */
public suspend inline fun HoneycodeClient.listTableColumns(crossinline block: ListTableColumnsRequest.Builder.() -> Unit): ListTableColumnsResponse = listTableColumns(ListTableColumnsRequest.Builder().apply(block).build())

/**
 * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
 */
public suspend inline fun HoneycodeClient.listTableRows(crossinline block: ListTableRowsRequest.Builder.() -> Unit): ListTableRowsResponse = listTableRows(ListTableRowsRequest.Builder().apply(block).build())

/**
 * The ListTables API allows you to retrieve a list of all the tables in a workbook.
 */
public suspend inline fun HoneycodeClient.listTables(crossinline block: ListTablesRequest.Builder.() -> Unit): ListTablesResponse = listTables(ListTablesRequest.Builder().apply(block).build())

/**
 * The ListTagsForResource API allows you to return a resource's tags.
 */
public suspend inline fun HoneycodeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
 */
public suspend inline fun HoneycodeClient.queryTableRows(crossinline block: QueryTableRowsRequest.Builder.() -> Unit): QueryTableRowsResponse = queryTableRows(QueryTableRowsRequest.Builder().apply(block).build())

/**
 * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API.
 */
public suspend inline fun HoneycodeClient.startTableDataImportJob(crossinline block: StartTableDataImportJobRequest.Builder.() -> Unit): StartTableDataImportJobResponse = startTableDataImportJob(StartTableDataImportJobRequest.Builder().apply(block).build())

/**
 * The TagResource API allows you to add tags to an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
 */
public suspend inline fun HoneycodeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The UntagResource API allows you to removes tags from an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
 */
public suspend inline fun HoneycodeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
