// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.serde

import aws.sdk.kotlin.services.honeycode.model.ImportDataSource
import aws.sdk.kotlin.services.honeycode.model.ImportOptions
import aws.sdk.kotlin.services.honeycode.model.ImportSourceDataFormat
import aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartTableDataImportJobOperationSerializer: HttpSerialize<StartTableDataImportJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartTableDataImportJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workbooks",
                "${input.workbookId}".encodeLabel(),
                "tables",
                "${input.destinationTableId}".encodeLabel(),
                "import",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeStartTableDataImportJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartTableDataImportJobOperationBody(context: ExecutionContext, input: StartTableDataImportJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val DATAFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dataFormat"))
    val DATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataSource"))
    val IMPORTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("importOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(DATAFORMAT_DESCRIPTOR)
        field(DATASOURCE_DESCRIPTOR)
        field(IMPORTOPTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        input.dataFormat?.let { field(DATAFORMAT_DESCRIPTOR, it.value) }
        input.dataSource?.let { field(DATASOURCE_DESCRIPTOR, it, ::serializeImportDataSourceDocument) }
        input.importOptions?.let { field(IMPORTOPTIONS_DESCRIPTOR, it, ::serializeImportOptionsDocument) }
    }
    return serializer.toByteArray()
}
