// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



public class QueryTableRowsRequest private constructor(builder: Builder) {
    /**
     * An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.
     */
    public val filterFormula: aws.sdk.kotlin.services.honeycode.model.Filter? = builder.filterFormula
    /**
     * The maximum number of rows to return in each page of the results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
     *
     *  Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the table whose rows are being queried.
     *
     *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public val tableId: kotlin.String? = requireNotNull(builder.tableId) { "A non-null value must be provided for tableId" }
    /**
     * The ID of the workbook whose table rows are being queried.
     *
     *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public val workbookId: kotlin.String? = requireNotNull(builder.workbookId) { "A non-null value must be provided for workbookId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryTableRowsRequest(")
        append("filterFormula=$filterFormula,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("tableId=$tableId,")
        append("workbookId=$workbookId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filterFormula?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryTableRowsRequest

        if (filterFormula != other.filterFormula) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (tableId != other.tableId) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.
         */
        public var filterFormula: aws.sdk.kotlin.services.honeycode.model.Filter? = null
        /**
         * The maximum number of rows to return in each page of the results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         *
         *  Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ID of the table whose rows are being queried.
         *
         *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        public var tableId: kotlin.String? = null
        /**
         * The ID of the workbook whose table rows are being queried.
         *
         *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        public var workbookId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest) : this() {
            this.filterFormula = x.filterFormula
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.tableId = x.tableId
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest = QueryTableRowsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.honeycode.model.Filter] inside the given [block]
         */
        public fun filterFormula(block: aws.sdk.kotlin.services.honeycode.model.Filter.Builder.() -> kotlin.Unit) {
            this.filterFormula = aws.sdk.kotlin.services.honeycode.model.Filter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterFormula == null) filterFormula = Filter.Builder().correctErrors().build()
            if (tableId == null) tableId = ""
            if (workbookId == null) workbookId = ""
            return this
        }
    }
}
