// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



public class GetScreenDataRequest private constructor(builder: Builder) {
    /**
     * The ID of the app that contains the screen.
     */
    public val appId: kotlin.String? = builder.appId
    /**
     * The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100.
     *
     *  This parameter is optional. If you don't specify this parameter, the default page size is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
     *
     *  Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the screen.
     */
    public val screenId: kotlin.String? = builder.screenId
    /**
     * Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen.
     */
    public val variables: Map<String, VariableValue>? = builder.variables
    /**
     * The ID of the workbook that contains the screen.
     */
    public val workbookId: kotlin.String? = builder.workbookId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.GetScreenDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetScreenDataRequest(")
        append("appId=$appId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("screenId=$screenId,")
        append("variables=*** Sensitive Data Redacted ***,")
        append("workbookId=$workbookId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (screenId?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetScreenDataRequest

        if (appId != other.appId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (screenId != other.screenId) return false
        if (variables != other.variables) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.GetScreenDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the app that contains the screen.
         */
        public var appId: kotlin.String? = null
        /**
         * The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100.
         *
         *  This parameter is optional. If you don't specify this parameter, the default page size is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
         *
         *  Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ID of the screen.
         */
        public var screenId: kotlin.String? = null
        /**
         * Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen.
         */
        public var variables: Map<String, VariableValue>? = null
        /**
         * The ID of the workbook that contains the screen.
         */
        public var workbookId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.GetScreenDataRequest) : this() {
            this.appId = x.appId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.screenId = x.screenId
            this.variables = x.variables
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.GetScreenDataRequest = GetScreenDataRequest(this)

        internal fun correctErrors(): Builder {
            if (appId == null) appId = ""
            if (screenId == null) screenId = ""
            if (workbookId == null) workbookId = ""
            return this
        }
    }
}
