// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



public class BatchCreateTableRowsRequest private constructor(builder: Builder) {
    /**
     * The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again.
     *
     *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list.
     *
     *  Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table.
     */
    public val rowsToCreate: List<CreateRowData>? = builder.rowsToCreate
    /**
     * The ID of the table where the new rows are being added.
     *
     *  If a table with the specified ID could not be found, this API throws ResourceNotFoundException.
     */
    public val tableId: kotlin.String? = requireNotNull(builder.tableId) { "A non-null value must be provided for tableId" }
    /**
     * The ID of the workbook where the new rows are being added.
     *
     *  If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException.
     */
    public val workbookId: kotlin.String? = requireNotNull(builder.workbookId) { "A non-null value must be provided for workbookId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchCreateTableRowsRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("rowsToCreate=$rowsToCreate,")
        append("tableId=$tableId,")
        append("workbookId=$workbookId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (rowsToCreate?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchCreateTableRowsRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (rowsToCreate != other.rowsToCreate) return false
        if (tableId != other.tableId) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again.
         *
         *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list.
         *
         *  Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table.
         */
        public var rowsToCreate: List<CreateRowData>? = null
        /**
         * The ID of the table where the new rows are being added.
         *
         *  If a table with the specified ID could not be found, this API throws ResourceNotFoundException.
         */
        public var tableId: kotlin.String? = null
        /**
         * The ID of the workbook where the new rows are being added.
         *
         *  If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException.
         */
        public var workbookId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.rowsToCreate = x.rowsToCreate
            this.tableId = x.tableId
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest = BatchCreateTableRowsRequest(this)

        internal fun correctErrors(): Builder {
            if (rowsToCreate == null) rowsToCreate = emptyList()
            if (tableId == null) tableId = ""
            if (workbookId == null) workbookId = ""
            return this
        }
    }
}
