// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.transform

import aws.sdk.kotlin.services.honeycode.model.BatchUpdateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.UpdateRowData
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchUpdateTableRowsOperationSerializer: HttpSerialize<BatchUpdateTableRowsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchUpdateTableRowsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workbooks",
                "${input.workbookId}".encodeLabel(),
                "tables",
                "${input.tableId}".encodeLabel(),
                "rows",
                "batchupdate",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeBatchUpdateTableRowsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchUpdateTableRowsOperationBody(context: ExecutionContext, input: BatchUpdateTableRowsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val ROWSTOUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rowsToUpdate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ROWSTOUPDATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        if (input.rowsToUpdate != null) {
            listField(ROWSTOUPDATE_DESCRIPTOR) {
                for (el0 in input.rowsToUpdate) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeUpdateRowDataDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
