// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.transform

import aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.FailedBatchItem
import aws.sdk.kotlin.services.honeycode.model.HoneycodeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class BatchCreateTableRowsOperationDeserializer: HttpDeserialize<BatchCreateTableRowsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchCreateTableRowsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchCreateTableRowsError(context, call)
        }
        val builder = BatchCreateTableRowsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchCreateTableRowsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchCreateTableRowsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw HoneycodeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestTimeoutException" -> RequestTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> HoneycodeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchCreateTableRowsOperationBody(builder: BatchCreateTableRowsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("createdRows"))
    val FAILEDBATCHITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedBatchItems"))
    val WORKBOOKCURSOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("workbookCursor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDROWS_DESCRIPTOR)
        field(FAILEDBATCHITEMS_DESCRIPTOR)
        field(WORKBOOKCURSOR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDROWS_DESCRIPTOR.index -> builder.createdRows =
                    deserializer.deserializeMap(CREATEDROWS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                FAILEDBATCHITEMS_DESCRIPTOR.index -> builder.failedBatchItems =
                    deserializer.deserializeList(FAILEDBATCHITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedBatchItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedBatchItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WORKBOOKCURSOR_DESCRIPTOR.index -> builder.workbookCursor = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
