// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.model



public class BatchDeleteTableRowsRequest private constructor(builder: Builder) {
    /**
     * The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.
     *
     *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The list of row ids to delete from the table. You need to specify at least one row id in this list.
     *
     *  Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table.
     */
    public val rowIds: List<String>? = builder.rowIds
    /**
     * The ID of the table where the rows are being deleted.
     *
     *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public val tableId: kotlin.String? = requireNotNull(builder.tableId) { "A non-null value must be provided for tableId" }
    /**
     * The ID of the workbook where the rows are being deleted.
     *
     *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
     */
    public val workbookId: kotlin.String? = requireNotNull(builder.workbookId) { "A non-null value must be provided for workbookId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchDeleteTableRowsRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("rowIds=$rowIds,")
        append("tableId=$tableId,")
        append("workbookId=$workbookId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (rowIds?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (workbookId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchDeleteTableRowsRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (rowIds != other.rowIds) return false
        if (tableId != other.tableId) return false
        if (workbookId != other.workbookId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again.
         *
         *  Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The list of row ids to delete from the table. You need to specify at least one row id in this list.
         *
         *  Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table.
         */
        public var rowIds: List<String>? = null
        /**
         * The ID of the table where the rows are being deleted.
         *
         *  If a table with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        public var tableId: kotlin.String? = null
        /**
         * The ID of the workbook where the rows are being deleted.
         *
         *  If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
         */
        public var workbookId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.rowIds = x.rowIds
            this.tableId = x.tableId
            this.workbookId = x.workbookId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsRequest = BatchDeleteTableRowsRequest(this)
    }
}
