// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.honeycode.model.HoneycodeException
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.TableRow
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListTableRowsOperationDeserializer: HttpDeserialize<ListTableRowsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTableRowsResponse {
        if (!response.status.isSuccess()) {
            throwListTableRowsError(context, response)
        }
        val builder = ListTableRowsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTableRowsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTableRowsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HoneycodeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestTimeoutException" -> RequestTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> HoneycodeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTableRowsOperationBody(builder: ListTableRowsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLUMNIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("columnIds"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val ROWIDSNOTFOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rowIdsNotFound"))
    val ROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rows"))
    val WORKBOOKCURSOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("workbookCursor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLUMNIDS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(ROWIDSNOTFOUND_DESCRIPTOR)
        field(ROWS_DESCRIPTOR)
        field(WORKBOOKCURSOR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLUMNIDS_DESCRIPTOR.index -> builder.columnIds =
                    deserializer.deserializeList(COLUMNIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                ROWIDSNOTFOUND_DESCRIPTOR.index -> builder.rowIdsNotFound =
                    deserializer.deserializeList(ROWIDSNOTFOUND_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROWS_DESCRIPTOR.index -> builder.rows =
                    deserializer.deserializeList(ROWS_DESCRIPTOR) {
                        val col0 = mutableListOf<TableRow>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTableRowDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WORKBOOKCURSOR_DESCRIPTOR.index -> builder.workbookCursor = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
