// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.honeycode.model.HoneycodeException
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsResponse
import aws.sdk.kotlin.services.honeycode.model.TableColumn
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListTableColumnsOperationDeserializer: HttpDeserialize<ListTableColumnsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTableColumnsResponse {
        if (!response.status.isSuccess()) {
            throwListTableColumnsError(context, response)
        }
        val builder = ListTableColumnsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTableColumnsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTableColumnsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HoneycodeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestTimeoutException" -> RequestTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> HoneycodeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTableColumnsOperationBody(builder: ListTableColumnsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val TABLECOLUMNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tableColumns"))
    val WORKBOOKCURSOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("workbookCursor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(TABLECOLUMNS_DESCRIPTOR)
        field(WORKBOOKCURSOR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TABLECOLUMNS_DESCRIPTOR.index -> builder.tableColumns =
                    deserializer.deserializeList(TABLECOLUMNS_DESCRIPTOR) {
                        val col0 = mutableListOf<TableColumn>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTableColumnDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WORKBOOKCURSOR_DESCRIPTOR.index -> builder.workbookCursor = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
