// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.honeycode.model.HoneycodeException
import aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InvokeScreenAutomationOperationDeserializer: HttpDeserialize<InvokeScreenAutomationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): InvokeScreenAutomationResponse {
        if (!response.status.isSuccess()) {
            throwInvokeScreenAutomationError(context, response)
        }
        val builder = InvokeScreenAutomationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInvokeScreenAutomationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwInvokeScreenAutomationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw HoneycodeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AutomationExecutionException" -> AutomationExecutionExceptionDeserializer().deserialize(context, wrappedResponse)
        "AutomationExecutionTimeoutException" -> AutomationExecutionTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestTimeoutException" -> RequestTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> HoneycodeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInvokeScreenAutomationOperationBody(builder: InvokeScreenAutomationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WORKBOOKCURSOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("workbookCursor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WORKBOOKCURSOR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WORKBOOKCURSOR_DESCRIPTOR.index -> builder.workbookCursor = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
