// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.honeycode

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.honeycode.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.honeycode.model.*
import aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchCreateTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchDeleteTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.BatchUpdateTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchUpdateTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.BatchUpsertTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.DescribeTableDataImportJobRequest
import aws.sdk.kotlin.services.honeycode.model.DescribeTableDataImportJobResponse
import aws.sdk.kotlin.services.honeycode.model.GetScreenDataRequest
import aws.sdk.kotlin.services.honeycode.model.GetScreenDataResponse
import aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationRequest
import aws.sdk.kotlin.services.honeycode.model.InvokeScreenAutomationResponse
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableColumnsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.ListTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.ListTablesRequest
import aws.sdk.kotlin.services.honeycode.model.ListTablesResponse
import aws.sdk.kotlin.services.honeycode.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.honeycode.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsRequest
import aws.sdk.kotlin.services.honeycode.model.QueryTableRowsResponse
import aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobRequest
import aws.sdk.kotlin.services.honeycode.model.StartTableDataImportJobResponse
import aws.sdk.kotlin.services.honeycode.model.TagResourceRequest
import aws.sdk.kotlin.services.honeycode.model.TagResourceResponse
import aws.sdk.kotlin.services.honeycode.model.UntagResourceRequest
import aws.sdk.kotlin.services.honeycode.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals, resources, and even your team.
 */
public interface HoneycodeClient : SdkClient {

    override val serviceName: String
        get() = "Honeycode"
    /**
     * HoneycodeClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): HoneycodeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultHoneycodeClient(config)
        }

        public operator fun invoke(config: Config): HoneycodeClient = DefaultHoneycodeClient(config)

        /**
         * Construct a [HoneycodeClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): HoneycodeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultHoneycodeClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API allows you to specify the values to set in some or all of the columns in the new rows.
     *
     *  If a column is not explicitly set in a specific row, then the column level formula specified in the table will be applied to the new row. If there is no column level formula but the last row of the table has a formula, then that formula will be copied down to the new row. If there is no column level formula and no formula in the last row of the table, then that column will be left blank for the new rows.
     */
    public suspend fun batchCreateTableRows(input: BatchCreateTableRowsRequest): BatchCreateTableRowsResponse

    /**
     * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table.
     */
    public suspend fun batchDeleteTableRows(input: BatchDeleteTableRowsRequest): BatchDeleteTableRowsResponse

    /**
     * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
     *
     *  You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     */
    public suspend fun batchUpdateTableRows(input: BatchUpdateTableRowsRequest): BatchUpdateTableRowsResponse

    /**
     * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are found, it will update the cells in the matching rows to new values specified in the request. If no matching rows are found, a new row is added at the end of the table and the cells in that row are set to the new values specified in the request.
     *
     *  You can specify the values to set in some or all of the columns in the table for the matching or newly appended rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
     */
    public suspend fun batchUpsertTableRows(input: BatchUpsertTableRowsRequest): BatchUpsertTableRowsResponse

    /**
     * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
     */
    public suspend fun describeTableDataImportJob(input: DescribeTableDataImportJobRequest): DescribeTableDataImportJobResponse

    /**
     * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
     */
    public suspend fun getScreenData(input: GetScreenDataRequest): GetScreenDataResponse

    /**
     * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook.
     */
    public suspend fun invokeScreenAutomation(input: InvokeScreenAutomationRequest): InvokeScreenAutomationResponse

    /**
     * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
     */
    public suspend fun listTableColumns(input: ListTableColumnsRequest): ListTableColumnsResponse

    /**
     * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
     */
    public suspend fun listTableRows(input: ListTableRowsRequest): ListTableRowsResponse

    /**
     * The ListTables API allows you to retrieve a list of all the tables in a workbook.
     */
    public suspend fun listTables(input: ListTablesRequest): ListTablesResponse

    /**
     * The ListTagsForResource API allows you to return a resource's tags.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
     */
    public suspend fun queryTableRows(input: QueryTableRowsRequest): QueryTableRowsResponse

    /**
     * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API.
     */
    public suspend fun startTableDataImportJob(input: StartTableDataImportJobRequest): StartTableDataImportJobResponse

    /**
     * The TagResource API allows you to add tags to an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The UntagResource API allows you to removes tags from an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API allows you to specify the values to set in some or all of the columns in the new rows.
 *
 *  If a column is not explicitly set in a specific row, then the column level formula specified in the table will be applied to the new row. If there is no column level formula but the last row of the table has a formula, then that formula will be copied down to the new row. If there is no column level formula and no formula in the last row of the table, then that column will be left blank for the new rows.
 */
public suspend inline fun HoneycodeClient.batchCreateTableRows(crossinline block: BatchCreateTableRowsRequest.Builder.() -> Unit): BatchCreateTableRowsResponse = batchCreateTableRows(BatchCreateTableRowsRequest.Builder().apply(block).build())

/**
 * The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table.
 */
public suspend inline fun HoneycodeClient.batchDeleteTableRows(crossinline block: BatchDeleteTableRowsRequest.Builder.() -> Unit): BatchDeleteTableRowsResponse = batchDeleteTableRows(BatchDeleteTableRowsRequest.Builder().apply(block).build())

/**
 * The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
 *
 *  You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
 */
public suspend inline fun HoneycodeClient.batchUpdateTableRows(crossinline block: BatchUpdateTableRowsRequest.Builder.() -> Unit): BatchUpdateTableRowsResponse = batchUpdateTableRows(BatchUpdateTableRowsRequest.Builder().apply(block).build())

/**
 * The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are found, it will update the cells in the matching rows to new values specified in the request. If no matching rows are found, a new row is added at the end of the table and the cells in that row are set to the new values specified in the request.
 *
 *  You can specify the values to set in some or all of the columns in the table for the matching or newly appended rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string ("").
 */
public suspend inline fun HoneycodeClient.batchUpsertTableRows(crossinline block: BatchUpsertTableRowsRequest.Builder.() -> Unit): BatchUpsertTableRowsResponse = batchUpsertTableRows(BatchUpsertTableRowsRequest.Builder().apply(block).build())

/**
 * The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
 */
public suspend inline fun HoneycodeClient.describeTableDataImportJob(crossinline block: DescribeTableDataImportJobRequest.Builder.() -> Unit): DescribeTableDataImportJobResponse = describeTableDataImportJob(DescribeTableDataImportJobRequest.Builder().apply(block).build())

/**
 * The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen.
 */
public suspend inline fun HoneycodeClient.getScreenData(crossinline block: GetScreenDataRequest.Builder.() -> Unit): GetScreenDataResponse = getScreenData(GetScreenDataRequest.Builder().apply(block).build())

/**
 * The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook.
 */
public suspend inline fun HoneycodeClient.invokeScreenAutomation(crossinline block: InvokeScreenAutomationRequest.Builder.() -> Unit): InvokeScreenAutomationResponse = invokeScreenAutomation(InvokeScreenAutomationRequest.Builder().apply(block).build())

/**
 * The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
 */
public suspend inline fun HoneycodeClient.listTableColumns(crossinline block: ListTableColumnsRequest.Builder.() -> Unit): ListTableColumnsResponse = listTableColumns(ListTableColumnsRequest.Builder().apply(block).build())

/**
 * The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
 */
public suspend inline fun HoneycodeClient.listTableRows(crossinline block: ListTableRowsRequest.Builder.() -> Unit): ListTableRowsResponse = listTableRows(ListTableRowsRequest.Builder().apply(block).build())

/**
 * The ListTables API allows you to retrieve a list of all the tables in a workbook.
 */
public suspend inline fun HoneycodeClient.listTables(crossinline block: ListTablesRequest.Builder.() -> Unit): ListTablesResponse = listTables(ListTablesRequest.Builder().apply(block).build())

/**
 * The ListTagsForResource API allows you to return a resource's tags.
 */
public suspend inline fun HoneycodeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
 */
public suspend inline fun HoneycodeClient.queryTableRows(crossinline block: QueryTableRowsRequest.Builder.() -> Unit): QueryTableRowsResponse = queryTableRows(QueryTableRowsRequest.Builder().apply(block).build())

/**
 * The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API.
 */
public suspend inline fun HoneycodeClient.startTableDataImportJob(crossinline block: StartTableDataImportJobRequest.Builder.() -> Unit): StartTableDataImportJobResponse = startTableDataImportJob(StartTableDataImportJobRequest.Builder().apply(block).build())

/**
 * The TagResource API allows you to add tags to an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
 */
public suspend inline fun HoneycodeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The UntagResource API allows you to removes tags from an ARN-able resource. Resource includes workbook, table, screen and screen-automation.
 */
public suspend inline fun HoneycodeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
