// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.waiters

import aws.sdk.kotlin.services.groundstation.GroundStationClient
import aws.sdk.kotlin.services.groundstation.model.DescribeContactRequest
import aws.sdk.kotlin.services.groundstation.model.DescribeContactResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


/**
 * Waits until a contact has been scheduled
 */
public suspend fun GroundStationClient.waitUntilContactScheduled(request: DescribeContactRequest): Outcome<DescribeContactResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 900_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeContactRequest, DescribeContactResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val contactStatus = it.contactStatus?.value
            contactStatus == "FAILED_TO_SCHEDULE"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val contactStatus = it.contactStatus?.value
            contactStatus == "SCHEDULED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeContact(request) }
}

/**
 * Waits until a contact has been scheduled
 */
public suspend fun GroundStationClient.waitUntilContactScheduled(block: DescribeContactRequest.Builder.() -> Unit): Outcome<DescribeContactResponse> =
    waitUntilContactScheduled(DescribeContactRequest.Builder().apply(block).build())
