// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.ContactStatus
import aws.sdk.kotlin.services.groundstation.model.ListContactsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListContactsOperationSerializer: HttpSerializer.NonStreaming<ListContactsRequest> {
    override fun serialize(context: ExecutionContext, input: ListContactsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/contacts"
        }

        val payload = serializeListContactsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListContactsOperationBody(context: ExecutionContext, input: ListContactsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val GROUNDSTATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("groundStation"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val MISSIONPROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("missionProfileArn"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SATELLITEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("satelliteArn"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("statusList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(GROUNDSTATION_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(MISSIONPROFILEARN_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SATELLITEARN_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUSLIST_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        field(ENDTIME_DESCRIPTOR, input.endTime, TimestampFormat.EPOCH_SECONDS)
        input.groundStation?.let { field(GROUNDSTATION_DESCRIPTOR, it) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.missionProfileArn?.let { field(MISSIONPROFILEARN_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.satelliteArn?.let { field(SATELLITEARN_DESCRIPTOR, it) }
        field(STARTTIME_DESCRIPTOR, input.startTime, TimestampFormat.EPOCH_SECONDS)
        listField(STATUSLIST_DESCRIPTOR) {
            for (el0 in input.statusList) {
                serializeString(el0.value)
            }
        }
    }
    return serializer.toByteArray()
}
