// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.EphemerisMetaData
import aws.sdk.kotlin.services.groundstation.model.GetSatelliteResponse
import aws.sdk.kotlin.services.groundstation.model.GroundStationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSatelliteOperationDeserializer: HttpDeserializer.NonStreaming<GetSatelliteResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSatelliteResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSatelliteError(context, call, payload)
        }
        val builder = GetSatelliteResponse.Builder()

        if (payload != null) {
            deserializeGetSatelliteOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSatelliteError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GroundStationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyException" -> DependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GroundStationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSatelliteOperationBody(builder: GetSatelliteResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CURRENTEPHEMERIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("currentEphemeris"))
    val GROUNDSTATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("groundStations"))
    val NORADSATELLITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("noradSatelliteID"))
    val SATELLITEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("satelliteArn"))
    val SATELLITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("satelliteId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTEPHEMERIS_DESCRIPTOR)
        field(GROUNDSTATIONS_DESCRIPTOR)
        field(NORADSATELLITEID_DESCRIPTOR)
        field(SATELLITEARN_DESCRIPTOR)
        field(SATELLITEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CURRENTEPHEMERIS_DESCRIPTOR.index -> builder.currentEphemeris = deserializeEphemerisMetaDataDocument(deserializer)
                GROUNDSTATIONS_DESCRIPTOR.index -> builder.groundStations =
                    deserializer.deserializeList(GROUNDSTATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NORADSATELLITEID_DESCRIPTOR.index -> builder.noradSatelliteId = deserializeInt()
                SATELLITEARN_DESCRIPTOR.index -> builder.satelliteArn = deserializeString()
                SATELLITEID_DESCRIPTOR.index -> builder.satelliteId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
