// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.GetMissionProfileResponse
import aws.sdk.kotlin.services.groundstation.model.GroundStationException
import aws.sdk.kotlin.services.groundstation.model.KmsKey
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetMissionProfileOperationDeserializer: HttpDeserializer.NonStreaming<GetMissionProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMissionProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMissionProfileError(context, call, payload)
        }
        val builder = GetMissionProfileResponse.Builder()

        if (payload != null) {
            deserializeGetMissionProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMissionProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GroundStationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyException" -> DependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GroundStationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMissionProfileOperationBody(builder: GetMissionProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTPOSTPASSDURATIONSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("contactPostPassDurationSeconds"))
    val CONTACTPREPASSDURATIONSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("contactPrePassDurationSeconds"))
    val DATAFLOWEDGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataflowEdges"))
    val DATAFLOWEDGES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val MINIMUMVIABLECONTACTDURATIONSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minimumViableContactDurationSeconds"))
    val MISSIONPROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("missionProfileArn"))
    val MISSIONPROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("missionProfileId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val STREAMSKMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("streamsKmsKey"))
    val STREAMSKMSROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("streamsKmsRole"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRACKINGCONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trackingConfigArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTPOSTPASSDURATIONSECONDS_DESCRIPTOR)
        field(CONTACTPREPASSDURATIONSECONDS_DESCRIPTOR)
        field(DATAFLOWEDGES_DESCRIPTOR)
        field(MINIMUMVIABLECONTACTDURATIONSECONDS_DESCRIPTOR)
        field(MISSIONPROFILEARN_DESCRIPTOR)
        field(MISSIONPROFILEID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(STREAMSKMSKEY_DESCRIPTOR)
        field(STREAMSKMSROLE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRACKINGCONFIGARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTPOSTPASSDURATIONSECONDS_DESCRIPTOR.index -> builder.contactPostPassDurationSeconds = deserializeInt()
                CONTACTPREPASSDURATIONSECONDS_DESCRIPTOR.index -> builder.contactPrePassDurationSeconds = deserializeInt()
                DATAFLOWEDGES_DESCRIPTOR.index -> builder.dataflowEdges =
                    deserializer.deserializeList(DATAFLOWEDGES_DESCRIPTOR) {
                        val col0 = mutableListOf<List<String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(DATAFLOWEDGES_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<String>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                MINIMUMVIABLECONTACTDURATIONSECONDS_DESCRIPTOR.index -> builder.minimumViableContactDurationSeconds = deserializeInt()
                MISSIONPROFILEARN_DESCRIPTOR.index -> builder.missionProfileArn = deserializeString()
                MISSIONPROFILEID_DESCRIPTOR.index -> builder.missionProfileId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                STREAMSKMSKEY_DESCRIPTOR.index -> builder.streamsKmsKey = deserializeKmsKeyDocument(deserializer)
                STREAMSKMSROLE_DESCRIPTOR.index -> builder.streamsKmsRole = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRACKINGCONFIGARN_DESCRIPTOR.index -> builder.trackingConfigArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
