// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.EndpointDetails
import aws.sdk.kotlin.services.groundstation.model.GetDataflowEndpointGroupResponse
import aws.sdk.kotlin.services.groundstation.model.GroundStationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetDataflowEndpointGroupOperationDeserializer: HttpDeserializer.NonStreaming<GetDataflowEndpointGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDataflowEndpointGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDataflowEndpointGroupError(context, call, payload)
        }
        val builder = GetDataflowEndpointGroupResponse.Builder()

        if (payload != null) {
            deserializeGetDataflowEndpointGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDataflowEndpointGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GroundStationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyException" -> DependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GroundStationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataflowEndpointGroupOperationBody(builder: GetDataflowEndpointGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTPOSTPASSDURATIONSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("contactPostPassDurationSeconds"))
    val CONTACTPREPASSDURATIONSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("contactPrePassDurationSeconds"))
    val DATAFLOWENDPOINTGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataflowEndpointGroupArn"))
    val DATAFLOWENDPOINTGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataflowEndpointGroupId"))
    val ENDPOINTSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("endpointsDetails"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTPOSTPASSDURATIONSECONDS_DESCRIPTOR)
        field(CONTACTPREPASSDURATIONSECONDS_DESCRIPTOR)
        field(DATAFLOWENDPOINTGROUPARN_DESCRIPTOR)
        field(DATAFLOWENDPOINTGROUPID_DESCRIPTOR)
        field(ENDPOINTSDETAILS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTPOSTPASSDURATIONSECONDS_DESCRIPTOR.index -> builder.contactPostPassDurationSeconds = deserializeInt()
                CONTACTPREPASSDURATIONSECONDS_DESCRIPTOR.index -> builder.contactPrePassDurationSeconds = deserializeInt()
                DATAFLOWENDPOINTGROUPARN_DESCRIPTOR.index -> builder.dataflowEndpointGroupArn = deserializeString()
                DATAFLOWENDPOINTGROUPID_DESCRIPTOR.index -> builder.dataflowEndpointGroupId = deserializeString()
                ENDPOINTSDETAILS_DESCRIPTOR.index -> builder.endpointsDetails =
                    deserializer.deserializeList(ENDPOINTSDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<EndpointDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEndpointDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
