// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.DescribeEphemerisResponse
import aws.sdk.kotlin.services.groundstation.model.EphemerisInvalidReason
import aws.sdk.kotlin.services.groundstation.model.EphemerisStatus
import aws.sdk.kotlin.services.groundstation.model.EphemerisTypeDescription
import aws.sdk.kotlin.services.groundstation.model.GroundStationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class DescribeEphemerisOperationDeserializer: HttpDeserializer.NonStreaming<DescribeEphemerisResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeEphemerisResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEphemerisError(context, call, payload)
        }
        val builder = DescribeEphemerisResponse.Builder()

        if (payload != null) {
            deserializeDescribeEphemerisOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeEphemerisError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GroundStationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyException" -> DependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GroundStationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEphemerisOperationBody(builder: DescribeEphemerisResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enabled"))
    val EPHEMERISID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ephemerisId"))
    val INVALIDREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("invalidReason"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val SATELLITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("satelliteId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val SUPPLIEDDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("suppliedData"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(ENABLED_DESCRIPTOR)
        field(EPHEMERISID_DESCRIPTOR)
        field(INVALIDREASON_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(SATELLITEID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUPPLIEDDATA_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENABLED_DESCRIPTOR.index -> builder.enabled = deserializeBoolean()
                EPHEMERISID_DESCRIPTOR.index -> builder.ephemerisId = deserializeString()
                INVALIDREASON_DESCRIPTOR.index -> builder.invalidReason = deserializeString().let { EphemerisInvalidReason.fromValue(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PRIORITY_DESCRIPTOR.index -> builder.priority = deserializeInt()
                SATELLITEID_DESCRIPTOR.index -> builder.satelliteId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EphemerisStatus.fromValue(it) }
                SUPPLIEDDATA_DESCRIPTOR.index -> builder.suppliedData = deserializeEphemerisTypeDescriptionDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
