// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.ContactStatus
import aws.sdk.kotlin.services.groundstation.model.DataflowDetail
import aws.sdk.kotlin.services.groundstation.model.DescribeContactResponse
import aws.sdk.kotlin.services.groundstation.model.Elevation
import aws.sdk.kotlin.services.groundstation.model.GroundStationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeContactOperationDeserializer: HttpDeserializer.NonStreaming<DescribeContactResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeContactResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeContactError(context, call, payload)
        }
        val builder = DescribeContactResponse.Builder()

        if (payload != null) {
            deserializeDescribeContactOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeContactError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GroundStationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyException" -> DependencyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GroundStationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeContactOperationBody(builder: DescribeContactResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contactId"))
    val CONTACTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contactStatus"))
    val DATAFLOWLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataflowList"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val GROUNDSTATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("groundStation"))
    val MAXIMUMELEVATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maximumElevation"))
    val MISSIONPROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("missionProfileArn"))
    val POSTPASSENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("postPassEndTime"))
    val PREPASSSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("prePassStartTime"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val SATELLITEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("satelliteArn"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VISIBILITYENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("visibilityEndTime"))
    val VISIBILITYSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("visibilityStartTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTID_DESCRIPTOR)
        field(CONTACTSTATUS_DESCRIPTOR)
        field(DATAFLOWLIST_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(GROUNDSTATION_DESCRIPTOR)
        field(MAXIMUMELEVATION_DESCRIPTOR)
        field(MISSIONPROFILEARN_DESCRIPTOR)
        field(POSTPASSENDTIME_DESCRIPTOR)
        field(PREPASSSTARTTIME_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(SATELLITEARN_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VISIBILITYENDTIME_DESCRIPTOR)
        field(VISIBILITYSTARTTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTID_DESCRIPTOR.index -> builder.contactId = deserializeString()
                CONTACTSTATUS_DESCRIPTOR.index -> builder.contactStatus = deserializeString().let { ContactStatus.fromValue(it) }
                DATAFLOWLIST_DESCRIPTOR.index -> builder.dataflowList =
                    deserializer.deserializeList(DATAFLOWLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<DataflowDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataflowDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                GROUNDSTATION_DESCRIPTOR.index -> builder.groundStation = deserializeString()
                MAXIMUMELEVATION_DESCRIPTOR.index -> builder.maximumElevation = deserializeElevationDocument(deserializer)
                MISSIONPROFILEARN_DESCRIPTOR.index -> builder.missionProfileArn = deserializeString()
                POSTPASSENDTIME_DESCRIPTOR.index -> builder.postPassEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                PREPASSSTARTTIME_DESCRIPTOR.index -> builder.prePassStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                SATELLITEARN_DESCRIPTOR.index -> builder.satelliteArn = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VISIBILITYENDTIME_DESCRIPTOR.index -> builder.visibilityEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                VISIBILITYSTARTTIME_DESCRIPTOR.index -> builder.visibilityStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
