// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.serde

import aws.sdk.kotlin.services.groundstation.model.CreateEphemerisRequest
import aws.sdk.kotlin.services.groundstation.model.EphemerisData
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateEphemerisOperationSerializer: HttpSerializer.NonStreaming<CreateEphemerisRequest> {
    override fun serialize(context: ExecutionContext, input: CreateEphemerisRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/ephemeris"
        }

        val payload = serializeCreateEphemerisOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateEphemerisOperationBody(context: ExecutionContext, input: CreateEphemerisRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enabled"))
    val EPHEMERIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ephemeris"))
    val EXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expirationTime"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val SATELLITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("satelliteId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENABLED_DESCRIPTOR)
        field(EPHEMERIS_DESCRIPTOR)
        field(EXPIRATIONTIME_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(SATELLITEID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.enabled?.let { field(ENABLED_DESCRIPTOR, it) }
        input.ephemeris?.let { field(EPHEMERIS_DESCRIPTOR, it, ::serializeEphemerisDataDocument) }
        input.expirationTime?.let { field(EXPIRATIONTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.kmsKeyArn?.let { field(KMSKEYARN_DESCRIPTOR, it) }
        field(NAME_DESCRIPTOR, input.name)
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
        field(SATELLITEID_DESCRIPTOR, input.satelliteId)
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
