// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.paginators

import aws.sdk.kotlin.services.groundstation.GroundStationClient
import aws.sdk.kotlin.services.groundstation.model.ConfigListItem
import aws.sdk.kotlin.services.groundstation.model.ContactData
import aws.sdk.kotlin.services.groundstation.model.DataflowEndpointListItem
import aws.sdk.kotlin.services.groundstation.model.EphemerisItem
import aws.sdk.kotlin.services.groundstation.model.GroundStationData
import aws.sdk.kotlin.services.groundstation.model.ListConfigsRequest
import aws.sdk.kotlin.services.groundstation.model.ListConfigsResponse
import aws.sdk.kotlin.services.groundstation.model.ListContactsRequest
import aws.sdk.kotlin.services.groundstation.model.ListContactsResponse
import aws.sdk.kotlin.services.groundstation.model.ListDataflowEndpointGroupsRequest
import aws.sdk.kotlin.services.groundstation.model.ListDataflowEndpointGroupsResponse
import aws.sdk.kotlin.services.groundstation.model.ListEphemeridesRequest
import aws.sdk.kotlin.services.groundstation.model.ListEphemeridesResponse
import aws.sdk.kotlin.services.groundstation.model.ListGroundStationsRequest
import aws.sdk.kotlin.services.groundstation.model.ListGroundStationsResponse
import aws.sdk.kotlin.services.groundstation.model.ListMissionProfilesRequest
import aws.sdk.kotlin.services.groundstation.model.ListMissionProfilesResponse
import aws.sdk.kotlin.services.groundstation.model.ListSatellitesRequest
import aws.sdk.kotlin.services.groundstation.model.ListSatellitesResponse
import aws.sdk.kotlin.services.groundstation.model.MissionProfileListItem
import aws.sdk.kotlin.services.groundstation.model.SatelliteListItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigsResponse]
 */
public fun GroundStationClient.listConfigsPaginated(initialRequest: ListConfigsRequest = ListConfigsRequest { }): Flow<ListConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigsPaginated.listConfigs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigsResponse]
 */
public fun GroundStationClient.listConfigsPaginated(block: ListConfigsRequest.Builder.() -> Unit): Flow<ListConfigsResponse> =
    listConfigsPaginated(ListConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigsPaginated]
 * to access the nested member [ConfigListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigListItem]
 */
@JvmName("listConfigsResponseConfigListItem")
public fun Flow<ListConfigsResponse>.configList(): Flow<ConfigListItem> =
    transform() { response ->
        response.configList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactsResponse]
 */
public fun GroundStationClient.listContactsPaginated(initialRequest: ListContactsRequest): Flow<ListContactsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactsPaginated.listContacts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListContactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactsResponse]
 */
public fun GroundStationClient.listContactsPaginated(block: ListContactsRequest.Builder.() -> Unit): Flow<ListContactsResponse> =
    listContactsPaginated(ListContactsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContactsPaginated]
 * to access the nested member [ContactData]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ContactData]
 */
@JvmName("listContactsResponseContactData")
public fun Flow<ListContactsResponse>.contactList(): Flow<ContactData> =
    transform() { response ->
        response.contactList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataflowEndpointGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataflowEndpointGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataflowEndpointGroupsResponse]
 */
public fun GroundStationClient.listDataflowEndpointGroupsPaginated(initialRequest: ListDataflowEndpointGroupsRequest = ListDataflowEndpointGroupsRequest { }): Flow<ListDataflowEndpointGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataflowEndpointGroupsPaginated.listDataflowEndpointGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataflowEndpointGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataflowEndpointGroupsResponse]
 */
public fun GroundStationClient.listDataflowEndpointGroupsPaginated(block: ListDataflowEndpointGroupsRequest.Builder.() -> Unit): Flow<ListDataflowEndpointGroupsResponse> =
    listDataflowEndpointGroupsPaginated(ListDataflowEndpointGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataflowEndpointGroupsPaginated]
 * to access the nested member [DataflowEndpointListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataflowEndpointListItem]
 */
@JvmName("listDataflowEndpointGroupsResponseDataflowEndpointListItem")
public fun Flow<ListDataflowEndpointGroupsResponse>.dataflowEndpointGroupList(): Flow<DataflowEndpointListItem> =
    transform() { response ->
        response.dataflowEndpointGroupList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEphemeridesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEphemeridesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEphemeridesResponse]
 */
public fun GroundStationClient.listEphemeridesPaginated(initialRequest: ListEphemeridesRequest): Flow<ListEphemeridesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEphemeridesPaginated.listEphemerides(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEphemeridesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEphemeridesResponse]
 */
public fun GroundStationClient.listEphemeridesPaginated(block: ListEphemeridesRequest.Builder.() -> Unit): Flow<ListEphemeridesResponse> =
    listEphemeridesPaginated(ListEphemeridesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEphemeridesPaginated]
 * to access the nested member [EphemerisItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EphemerisItem]
 */
@JvmName("listEphemeridesResponseEphemerisItem")
public fun Flow<ListEphemeridesResponse>.ephemerides(): Flow<EphemerisItem> =
    transform() { response ->
        response.ephemerides?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroundStationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroundStationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroundStationsResponse]
 */
public fun GroundStationClient.listGroundStationsPaginated(initialRequest: ListGroundStationsRequest = ListGroundStationsRequest { }): Flow<ListGroundStationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroundStationsPaginated.listGroundStations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroundStationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroundStationsResponse]
 */
public fun GroundStationClient.listGroundStationsPaginated(block: ListGroundStationsRequest.Builder.() -> Unit): Flow<ListGroundStationsResponse> =
    listGroundStationsPaginated(ListGroundStationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroundStationsPaginated]
 * to access the nested member [GroundStationData]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroundStationData]
 */
@JvmName("listGroundStationsResponseGroundStationData")
public fun Flow<ListGroundStationsResponse>.groundStationList(): Flow<GroundStationData> =
    transform() { response ->
        response.groundStationList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMissionProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMissionProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMissionProfilesResponse]
 */
public fun GroundStationClient.listMissionProfilesPaginated(initialRequest: ListMissionProfilesRequest = ListMissionProfilesRequest { }): Flow<ListMissionProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMissionProfilesPaginated.listMissionProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMissionProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMissionProfilesResponse]
 */
public fun GroundStationClient.listMissionProfilesPaginated(block: ListMissionProfilesRequest.Builder.() -> Unit): Flow<ListMissionProfilesResponse> =
    listMissionProfilesPaginated(ListMissionProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMissionProfilesPaginated]
 * to access the nested member [MissionProfileListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MissionProfileListItem]
 */
@JvmName("listMissionProfilesResponseMissionProfileListItem")
public fun Flow<ListMissionProfilesResponse>.missionProfileList(): Flow<MissionProfileListItem> =
    transform() { response ->
        response.missionProfileList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSatellitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSatellitesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSatellitesResponse]
 */
public fun GroundStationClient.listSatellitesPaginated(initialRequest: ListSatellitesRequest = ListSatellitesRequest { }): Flow<ListSatellitesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSatellitesPaginated.listSatellites(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSatellitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSatellitesResponse]
 */
public fun GroundStationClient.listSatellitesPaginated(block: ListSatellitesRequest.Builder.() -> Unit): Flow<ListSatellitesResponse> =
    listSatellitesPaginated(ListSatellitesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSatellitesPaginated]
 * to access the nested member [SatelliteListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SatelliteListItem]
 */
@JvmName("listSatellitesResponseSatelliteListItem")
public fun Flow<ListSatellitesResponse>.satellites(): Flow<SatelliteListItem> =
    transform() { response ->
        response.satellites?.forEach {
            emit(it)
        }
    }
