// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class UpdateMissionProfileRequest private constructor(builder: Builder) {
    /**
     * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.
     */
    public val contactPostPassDurationSeconds: kotlin.Int? = builder.contactPostPassDurationSeconds
    /**
     * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.
     */
    public val contactPrePassDurationSeconds: kotlin.Int? = builder.contactPrePassDurationSeconds
    /**
     * A list of lists of ARNs. Each list of ARNs is an edge, with a *from*`Config` and a *to*`Config`.
     */
    public val dataflowEdges: List<List<String>>? = builder.dataflowEdges
    /**
     * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.
     */
    public val minimumViableContactDurationSeconds: kotlin.Int? = builder.minimumViableContactDurationSeconds
    /**
     * UUID of a mission profile.
     */
    public val missionProfileId: kotlin.String = requireNotNull(builder.missionProfileId) { "A non-null value must be provided for missionProfileId" }
    /**
     * Name of a mission profile.
     */
    public val name: kotlin.String? = builder.name
    /**
     * KMS key to use for encrypting streams.
     */
    public val streamsKmsKey: aws.sdk.kotlin.services.groundstation.model.KmsKey? = builder.streamsKmsKey
    /**
     * Role to use for encrypting streams with KMS key.
     */
    public val streamsKmsRole: kotlin.String? = builder.streamsKmsRole
    /**
     * ARN of a tracking `Config`.
     */
    public val trackingConfigArn: kotlin.String? = builder.trackingConfigArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.UpdateMissionProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMissionProfileRequest(")
        append("contactPostPassDurationSeconds=$contactPostPassDurationSeconds,")
        append("contactPrePassDurationSeconds=$contactPrePassDurationSeconds,")
        append("dataflowEdges=$dataflowEdges,")
        append("minimumViableContactDurationSeconds=$minimumViableContactDurationSeconds,")
        append("missionProfileId=$missionProfileId,")
        append("name=$name,")
        append("streamsKmsKey=$streamsKmsKey,")
        append("streamsKmsRole=$streamsKmsRole,")
        append("trackingConfigArn=$trackingConfigArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactPostPassDurationSeconds ?: 0
        result = 31 * result + (contactPrePassDurationSeconds ?: 0)
        result = 31 * result + (dataflowEdges?.hashCode() ?: 0)
        result = 31 * result + (minimumViableContactDurationSeconds ?: 0)
        result = 31 * result + (missionProfileId.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (streamsKmsKey?.hashCode() ?: 0)
        result = 31 * result + (streamsKmsRole?.hashCode() ?: 0)
        result = 31 * result + (trackingConfigArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMissionProfileRequest

        if (contactPostPassDurationSeconds != other.contactPostPassDurationSeconds) return false
        if (contactPrePassDurationSeconds != other.contactPrePassDurationSeconds) return false
        if (dataflowEdges != other.dataflowEdges) return false
        if (minimumViableContactDurationSeconds != other.minimumViableContactDurationSeconds) return false
        if (missionProfileId != other.missionProfileId) return false
        if (name != other.name) return false
        if (streamsKmsKey != other.streamsKmsKey) return false
        if (streamsKmsRole != other.streamsKmsRole) return false
        if (trackingConfigArn != other.trackingConfigArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.UpdateMissionProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.
         */
        public var contactPostPassDurationSeconds: kotlin.Int? = null
        /**
         * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.
         */
        public var contactPrePassDurationSeconds: kotlin.Int? = null
        /**
         * A list of lists of ARNs. Each list of ARNs is an edge, with a *from*`Config` and a *to*`Config`.
         */
        public var dataflowEdges: List<List<String>>? = null
        /**
         * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.
         */
        public var minimumViableContactDurationSeconds: kotlin.Int? = null
        /**
         * UUID of a mission profile.
         */
        public var missionProfileId: kotlin.String? = null
        /**
         * Name of a mission profile.
         */
        public var name: kotlin.String? = null
        /**
         * KMS key to use for encrypting streams.
         */
        public var streamsKmsKey: aws.sdk.kotlin.services.groundstation.model.KmsKey? = null
        /**
         * Role to use for encrypting streams with KMS key.
         */
        public var streamsKmsRole: kotlin.String? = null
        /**
         * ARN of a tracking `Config`.
         */
        public var trackingConfigArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.UpdateMissionProfileRequest) : this() {
            this.contactPostPassDurationSeconds = x.contactPostPassDurationSeconds
            this.contactPrePassDurationSeconds = x.contactPrePassDurationSeconds
            this.dataflowEdges = x.dataflowEdges
            this.minimumViableContactDurationSeconds = x.minimumViableContactDurationSeconds
            this.missionProfileId = x.missionProfileId
            this.name = x.name
            this.streamsKmsKey = x.streamsKmsKey
            this.streamsKmsRole = x.streamsKmsRole
            this.trackingConfigArn = x.trackingConfigArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.UpdateMissionProfileRequest = UpdateMissionProfileRequest(this)

        internal fun correctErrors(): Builder {
            if (missionProfileId == null) missionProfileId = ""
            return this
        }
    }
}
