// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateEphemerisRequest private constructor(builder: Builder) {
    /**
     * Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be re-validated.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * The AWS Ground Station ephemeris ID.
     */
    public val ephemerisId: kotlin.String = requireNotNull(builder.ephemerisId) { "A non-null value must be provided for ephemerisId" }
    /**
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
     *
     * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
     *
     * Priority must be 1 or greater
     */
    public val priority: kotlin.Int? = builder.priority

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.UpdateEphemerisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEphemerisRequest(")
        append("enabled=$enabled,")
        append("ephemerisId=$ephemerisId,")
        append("name=$name,")
        append("priority=$priority")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (ephemerisId.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEphemerisRequest

        if (enabled != other.enabled) return false
        if (ephemerisId != other.ephemerisId) return false
        if (name != other.name) return false
        if (priority != other.priority) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.UpdateEphemerisRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be re-validated.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The AWS Ground Station ephemeris ID.
         */
        public var ephemerisId: kotlin.String? = null
        /**
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         */
        public var name: kotlin.String? = null
        /**
         * Customer-provided priority score to establish the order in which overlapping ephemerides should be used.
         *
         * The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.
         *
         * Priority must be 1 or greater
         */
        public var priority: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.UpdateEphemerisRequest) : this() {
            this.enabled = x.enabled
            this.ephemerisId = x.ephemerisId
            this.name = x.name
            this.priority = x.priority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.UpdateEphemerisRequest = UpdateEphemerisRequest(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            if (ephemerisId == null) ephemerisId = ""
            return this
        }
    }
}
