// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Object that describes a spectral `Config`.
 */
public class SpectrumConfig private constructor(builder: Builder) {
    /**
     * Bandwidth of a spectral `Config`. AWS Ground Station currently has the following bandwidth limitations:
     * + For `AntennaDownlinkDemodDecodeconfig`, valid values are between 125 kHz to 650 MHz.
     * + For `AntennaDownlinkconfig` valid values are between 10 kHz to 54 MHz.
     * + For `AntennaUplinkConfig`, valid values are between 10 kHz to 54 MHz.
     */
    public val bandwidth: aws.sdk.kotlin.services.groundstation.model.FrequencyBandwidth? = builder.bandwidth
    /**
     * Center frequency of a spectral `Config`. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
     */
    public val centerFrequency: aws.sdk.kotlin.services.groundstation.model.Frequency? = builder.centerFrequency
    /**
     * Polarization of a spectral `Config`. Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
     */
    public val polarization: aws.sdk.kotlin.services.groundstation.model.Polarization? = builder.polarization

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.SpectrumConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpectrumConfig(")
        append("bandwidth=$bandwidth,")
        append("centerFrequency=$centerFrequency,")
        append("polarization=$polarization")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bandwidth?.hashCode() ?: 0
        result = 31 * result + (centerFrequency?.hashCode() ?: 0)
        result = 31 * result + (polarization?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpectrumConfig

        if (bandwidth != other.bandwidth) return false
        if (centerFrequency != other.centerFrequency) return false
        if (polarization != other.polarization) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.SpectrumConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Bandwidth of a spectral `Config`. AWS Ground Station currently has the following bandwidth limitations:
         * + For `AntennaDownlinkDemodDecodeconfig`, valid values are between 125 kHz to 650 MHz.
         * + For `AntennaDownlinkconfig` valid values are between 10 kHz to 54 MHz.
         * + For `AntennaUplinkConfig`, valid values are between 10 kHz to 54 MHz.
         */
        public var bandwidth: aws.sdk.kotlin.services.groundstation.model.FrequencyBandwidth? = null
        /**
         * Center frequency of a spectral `Config`. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.
         */
        public var centerFrequency: aws.sdk.kotlin.services.groundstation.model.Frequency? = null
        /**
         * Polarization of a spectral `Config`. Capturing both `"RIGHT_HAND"` and `"LEFT_HAND"` polarization requires two separate configs.
         */
        public var polarization: aws.sdk.kotlin.services.groundstation.model.Polarization? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.SpectrumConfig) : this() {
            this.bandwidth = x.bandwidth
            this.centerFrequency = x.centerFrequency
            this.polarization = x.polarization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.SpectrumConfig = SpectrumConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.groundstation.model.FrequencyBandwidth] inside the given [block]
         */
        public fun bandwidth(block: aws.sdk.kotlin.services.groundstation.model.FrequencyBandwidth.Builder.() -> kotlin.Unit) {
            this.bandwidth = aws.sdk.kotlin.services.groundstation.model.FrequencyBandwidth.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.groundstation.model.Frequency] inside the given [block]
         */
        public fun centerFrequency(block: aws.sdk.kotlin.services.groundstation.model.Frequency.Builder.() -> kotlin.Unit) {
            this.centerFrequency = aws.sdk.kotlin.services.groundstation.model.Frequency.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
