// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about an S3 recording `Config`.
 */
public class S3RecordingConfig private constructor(builder: Builder) {
    /**
     * ARN of the bucket to record to.
     */
    public val bucketArn: kotlin.String = requireNotNull(builder.bucketArn) { "A non-null value must be provided for bucketArn" }
    /**
     * S3 Key prefix to prefice data files.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * ARN of the role Ground Station assumes to write data to the bucket.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.S3RecordingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3RecordingConfig(")
        append("bucketArn=$bucketArn,")
        append("prefix=$prefix,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn.hashCode()
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3RecordingConfig

        if (bucketArn != other.bucketArn) return false
        if (prefix != other.prefix) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.S3RecordingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of the bucket to record to.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * S3 Key prefix to prefice data files.
         */
        public var prefix: kotlin.String? = null
        /**
         * ARN of the role Ground Station assumes to write data to the bucket.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.S3RecordingConfig) : this() {
            this.bucketArn = x.bucketArn
            this.prefix = x.prefix
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.S3RecordingConfig = S3RecordingConfig(this)

        internal fun correctErrors(): Builder {
            if (bucketArn == null) bucketArn = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
