// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListEphemeridesRequest private constructor(builder: Builder) {
    /**
     * The end time to list in UTC. The operation will return an ephemeris if its expiration time is within the time range defined by the `startTime` and `endTime`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * Maximum number of ephemerides to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Pagination token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The AWS Ground Station satellite ID to list ephemeris for.
     */
    public val satelliteId: kotlin.String = requireNotNull(builder.satelliteId) { "A non-null value must be provided for satelliteId" }
    /**
     * The start time to list in UTC. The operation will return an ephemeris if its expiration time is within the time range defined by the `startTime` and `endTime`.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The list of ephemeris status to return.
     */
    public val statusList: List<EphemerisStatus>? = builder.statusList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.ListEphemeridesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEphemeridesRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("satelliteId=$satelliteId,")
        append("startTime=$startTime,")
        append("statusList=$statusList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime.hashCode()
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (satelliteId.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (statusList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEphemeridesRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (satelliteId != other.satelliteId) return false
        if (startTime != other.startTime) return false
        if (statusList != other.statusList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.ListEphemeridesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end time to list in UTC. The operation will return an ephemeris if its expiration time is within the time range defined by the `startTime` and `endTime`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Maximum number of ephemerides to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Pagination token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The AWS Ground Station satellite ID to list ephemeris for.
         */
        public var satelliteId: kotlin.String? = null
        /**
         * The start time to list in UTC. The operation will return an ephemeris if its expiration time is within the time range defined by the `startTime` and `endTime`.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of ephemeris status to return.
         */
        public var statusList: List<EphemerisStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.ListEphemeridesRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.satelliteId = x.satelliteId
            this.startTime = x.startTime
            this.statusList = x.statusList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.ListEphemeridesRequest = ListEphemeridesRequest(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (satelliteId == null) satelliteId = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
