// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class ListContactsRequest private constructor(builder: Builder) {
    /**
     * End time of a contact in UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * Name of a ground station.
     */
    public val groundStation: kotlin.String? = builder.groundStation
    /**
     * Maximum number of contacts returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * ARN of a mission profile.
     */
    public val missionProfileArn: kotlin.String? = builder.missionProfileArn
    /**
     * Next token returned in the request of a previous `ListContacts` call. Used to get the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * ARN of a satellite.
     */
    public val satelliteArn: kotlin.String? = builder.satelliteArn
    /**
     * Start time of a contact in UTC.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * Status of a contact reservation.
     */
    public val statusList: List<ContactStatus> = requireNotNull(builder.statusList) { "A non-null value must be provided for statusList" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.ListContactsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListContactsRequest(")
        append("endTime=$endTime,")
        append("groundStation=$groundStation,")
        append("maxResults=$maxResults,")
        append("missionProfileArn=$missionProfileArn,")
        append("nextToken=$nextToken,")
        append("satelliteArn=$satelliteArn,")
        append("startTime=$startTime,")
        append("statusList=$statusList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime.hashCode()
        result = 31 * result + (groundStation?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (missionProfileArn?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (satelliteArn?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (statusList.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListContactsRequest

        if (endTime != other.endTime) return false
        if (groundStation != other.groundStation) return false
        if (maxResults != other.maxResults) return false
        if (missionProfileArn != other.missionProfileArn) return false
        if (nextToken != other.nextToken) return false
        if (satelliteArn != other.satelliteArn) return false
        if (startTime != other.startTime) return false
        if (statusList != other.statusList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.ListContactsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * End time of a contact in UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Name of a ground station.
         */
        public var groundStation: kotlin.String? = null
        /**
         * Maximum number of contacts returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * ARN of a mission profile.
         */
        public var missionProfileArn: kotlin.String? = null
        /**
         * Next token returned in the request of a previous `ListContacts` call. Used to get the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * ARN of a satellite.
         */
        public var satelliteArn: kotlin.String? = null
        /**
         * Start time of a contact in UTC.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of a contact reservation.
         */
        public var statusList: List<ContactStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.ListContactsRequest) : this() {
            this.endTime = x.endTime
            this.groundStation = x.groundStation
            this.maxResults = x.maxResults
            this.missionProfileArn = x.missionProfileArn
            this.nextToken = x.nextToken
            this.satelliteArn = x.satelliteArn
            this.startTime = x.startTime
            this.statusList = x.statusList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.ListContactsRequest = ListContactsRequest(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (statusList == null) statusList = emptyList()
            return this
        }
    }
}
