// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.groundstation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata describing a particular ephemeris.
 */
public class EphemerisMetaData private constructor(builder: Builder) {
    /**
     * UUID of a customer-provided ephemeris.
     *
     * This field is not populated for default ephemerides from Space Track.
     */
    public val ephemerisId: kotlin.String? = builder.ephemerisId
    /**
     * The epoch of a default, ephemeris from Space Track in UTC.
     *
     * This field is not populated for customer-provided ephemerides.
     */
    public val epoch: aws.smithy.kotlin.runtime.time.Instant? = builder.epoch
    /**
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     *
     * A name is only returned for customer-provider ephemerides that have a name associated.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `EphemerisSource` that generated a given ephemeris.
     */
    public val source: aws.sdk.kotlin.services.groundstation.model.EphemerisSource = requireNotNull(builder.source) { "A non-null value must be provided for source" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.groundstation.model.EphemerisMetaData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EphemerisMetaData(")
        append("ephemerisId=$ephemerisId,")
        append("epoch=$epoch,")
        append("name=$name,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ephemerisId?.hashCode() ?: 0
        result = 31 * result + (epoch?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (source.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EphemerisMetaData

        if (ephemerisId != other.ephemerisId) return false
        if (epoch != other.epoch) return false
        if (name != other.name) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.groundstation.model.EphemerisMetaData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * UUID of a customer-provided ephemeris.
         *
         * This field is not populated for default ephemerides from Space Track.
         */
        public var ephemerisId: kotlin.String? = null
        /**
         * The epoch of a default, ephemeris from Space Track in UTC.
         *
         * This field is not populated for customer-provided ephemerides.
         */
        public var epoch: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         *
         * A name is only returned for customer-provider ephemerides that have a name associated.
         */
        public var name: kotlin.String? = null
        /**
         * The `EphemerisSource` that generated a given ephemeris.
         */
        public var source: aws.sdk.kotlin.services.groundstation.model.EphemerisSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.groundstation.model.EphemerisMetaData) : this() {
            this.ephemerisId = x.ephemerisId
            this.epoch = x.epoch
            this.name = x.name
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.groundstation.model.EphemerisMetaData = EphemerisMetaData(this)

        internal fun correctErrors(): Builder {
            if (source == null) source = EphemerisSource.SdkUnknown("no value provided")
            return this
        }
    }
}
